//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-4 : Basic equations in integral form for a control volume
//Example: 4.9   Page:125
//Topic: Nozzle flow: application of bernoulli equation  
//=======================================================================
model Ex4_9
//=======================================================
//Parameter Section
parameter Real p(unit="kg/m^3")=1000"Density of water";
parameter Real d1(unit="m")=0.075"Diameter at Nozzle inlet";
parameter Real d2(unit="m")=0.025"Diameter at the Nozzle outlet";
parameter Real q(unit="m^3/s")=0.02"Flow rate of water in nozzle";
parameter Real c1(unit="N*s/(kg*m^2)")=1"Unit conversion constant";
parameter Real c2(unit="Pa*m^2/N^2")=1"Unit conversion constant";
final constant Real pi=2*Modelica.Math.asin(1.0);
//=======================================================
//Variable Section

Real p1g(unit="Pa")"Inlet gage pressure";

//=======================================================
//Equation Section
equation
p1g=(8*p*q^2*(((d1/d2)^4)-1))/(pi^2*d1^4)"Expression for inlet gage pressure";

end Ex4_9;
//================================================================================
//Remark
//Answer is wrong in the book as the units are wrongly given as kPa
