model Ex5_2
  //Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015
  //Chapter-5 : Introduction to differential analysis of fluid motion
  //Example: 5.2   Page:176
  //Topic: Unsteady differential continuity equation
  //=======================================================================
  //=======================================================
  //Parameter Section
  parameter Real l(unit = "m") = 0.15 "Distance of the piston from the closed side";
  parameter Real v(unit = "m/s") = 12 "Velocity with which the piston moves";
  parameter Real po(unit = "kg/m^3") = 18 "Uniform gas density ";
  
  //=======================================================
  //Varaible Section
  Real p(unit="kg/m3", start=0);
  //=======================================================
  //Equation section
equation
  der(p)= -po*v/l "Expression for Change of gas density at that instant with units kg/(m^3*s)";
  
end Ex5_2;
//=========================================================================================
