//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-5 : Introduction to differential analysis of fluid motion
//Example: 5.2   Page:176
//Topic: Unsteady differential continuity equation  
//=======================================================================
package Ex5_7
class position
//=======================================================
//Parameter Section
parameter Real u1(unit="mm/s")=3"Local velocity at point b";
parameter Real t(unit="s")=1.5"Time";
//=======================================================
//Variable Section
Real delxb(unit="mm")"Change in position of b";
Real delxd(unit="mm")"Change in position of d";
Real delxa(unit="mm")"Change in position of a";
Real delxc(unit="mm")"Change in position of c";
//=======================================================
//Equation Section
equation
delxb=u1*t"Expression for delxb";
delxd=delxb"Expression for delxd";
delxa=0"Expression for delxa";
delxc=0"Expression for delxc";
end position;
//=========================================================================
class angdef
//=======================================================
//Parameter Section
parameter Real U(unit="m/s")=4"Velocity field";
parameter Real h(unit="m")=4"Height of the velocity field";

//=======================================================
//Variable Section
Real ad(unit="s^-1")"Rate of angular deformation";

//=======================================================
//Equation Section
equation
ad=U/h"Expression for rate of angular deformation";
end angdef;
//=========================================================================
class rrot
//=======================================================
//Parameter Section
parameter Real U(unit="m/s")=4"Velocity field";
parameter Real h(unit="m")=4"Height of the velocity field";

//=======================================================
//Variable Section
Real rr(unit="s^-1")"Rate of rotation of fluid particle";

//=======================================================
//Equation Section
equation
rr=0.5*U/h"Expression for rate of rotation of fluid particles";
end rrot;
//==================================================================
end Ex5_7;
//==================================================================
