
//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-7 : Dimensional analysis and simlitude
//Example: 7.4   Page:307
//Topic: Similarity: Drag of a sonar transducer
//=======================================================================
model Ex7_4

//=======================================================
//Parameter Section
parameter Real dp(unit="m")=0.3"Diameter of prototype";
parameter Real dm(unit="m")=152E-3"Diameter of model";
parameter Real vp(unit="m/s")=2.57"Fluid velocity in prototype";
parameter Real kp(unit="m^2/s")=1.57E-6"Fluid kinematic viscosity of prototype";
parameter Real km(unit="m^2/s")=1.46E-5"Fluid kinematic viscosity of model";
parameter Real pw(unit="kg/m^3")=1000"Density of water";
parameter Real pa(unit="kg/m^3")=1.227"Density of air";
parameter Real fm(unit="N")=2.7"Drag force incase of model";

//=======================================================
//Variable Section
Real fp(unit="N")"Drag force incase of prototype";
Real vm(unit="m/s")"Fluid velocity in model";
Real rep(unit="")"Reynolds number in prototype";
Real rem(unit="")"Reynolds number in model";

//=======================================================
//Equation Section
equation
rep=dp*vp/kp"Expression for reynolds number incase of prototype";
rep=rem"Incase  of simlitude";
rem=dm*vm/km"Expression for reynolds number incase of model";
fp=fm*pw*vp^2*dp^2/(pa*vm^2*dm^2)"Expression for drag incase of prototype";
end Ex7_4;
//====================================================================
