//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-9 : External incompressible flow
//Example: 9.4   Page:440
//Topic: Turbulent boundary layer on a flat plate: approximate solution using 1/7 power velocity profile 
//========================================================================================================
model Ex9_4

//=======================================================
//Parameter Section
parameter Real u(unit="m/s")=1"Freestream velocity of water";
parameter Real l(unit="m")=1"Length of flat plate";
parameter Real v(unit=" m^2/s")=1E-6"Kinematic Viscosity of water";
parameter Real p(unit="kg/m^3")=999"Density of water";
parameter Real c1(unit="N*s^2/(kg*m)")=1"Unit conversion constant";

//=======================================================
//Variable Section
Real rel(unit="")"Reynolds number for flow";
Real dellt(unit="m")"Disturbance thickness in turbulence regime";
Real dellts(unit="m")"Displacement thickness in turbulent regime";
Real cft(unit="")"Skin frition coefficient in turbulent regime";
Real twt(unit="N/m^2")"Wall shear stress in turbulent regime";
Real delll(unit="m")"Disturbance thickness in laminar regime";
Real dellls(unit="m")"Displacement thickness in laminar regime";
Real cfl(unit="")"Skin frition coefficient in laminar regime";
Real twl(unit="N/m^2")"Wall shear stress in laminar regime";
Real rdell(unit="")"Ratio of disturbance thickness in two regimes";
Real rdells(unit="")"Ratio of dispacement thickness in two regimes";
Real rtw(unit="")"Ratio of wall shear stress in two regimes";

//=======================================================
//Equation Section
equation
rel=u*l/v"Expression for reynolds number";
dellt=0.382*l/rel^0.2"Expression fro Disturbance thickness in turbulence regime ";
dellts=dellt/8"Expression for Displacement thickness in turbulent regime";
cft=0.0594/rel^0.2"Expression for Skin frition coefficient in turbulent regime ";
twt=cft*0.5*p*u^2*c1"Expression for Wall shear stress in turbulent regime";
delll=5*l/sqrt(rel)"Expression for Disturbance thickness in laminar regime";
dellls=0.344*delll"Expression for Displacement thickness in laminar regime ";
cfl=0.664/sqrt(rel)"Expression for Skin frition coefficient in laminar regime ";
twl=cfl*0.5*p*u^2"Expresion for Wall shear stress in laminar regime";
rdell=dellt/delll"Ratio of disturbance thickness in two regimes";
rdells=dellts/dellls"Ratio of Ratio of disturbance thickness in two regimes";
rtw=twt/twl"Ratio of wall shear stress in two regimes";
end Ex9_4;
//================================================================================
