//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-9 : External incompressible flow
//Example: 9.7   Page:455
//Topic: Deceleration of an automobile by a drag parachute
//================================================================
model Ex9_7

//=======================================================
//Parameter Section
parameter Real vo(unit="km/hr")=430"Initial speed of automobile";
parameter Real vf(unit="km/hr")=160"Final speed of automobile";
parameter Real w(unit="N")=7120"Drag resistance";
parameter Real cd(unit="")=1.42"Skin friction coefficient";
parameter Real p(unit="kg/m^3")=1.227"Density of air";
parameter Real g(unit="m/s^2")=9.81"Acceleraion due to gravity";
parameter Real a(unit="m^2")=2.3"Area of the drag chute";
parameter Real v(unit="m^2/s")=1.46E-5"Viscosity of air";
parameter Real c1(unit="km/m")=1E-3"Unit conversion constant";
parameter Real c2(unit="s/hr")=3600"Unit conversion constant";
parameter Real c3(unit="kg*m/(N*s^2)")=1"Unit conversion constant";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=======================================================
//Variable Section
Real t(unit="s")"Time required for decrease in velocity of automobile";
Real re(unit="")"Reynolds Number";

//=======================================================
//Equation
equation
t=(vo-vf)*2*w*c1*c2*c3/(vf*vo*cd*p*a*g)"Expression for time required";
re=((4*a/pi)^0.5)*vf/(v*c2*c1)"Expression for reynolds number";
end Ex9_7;
//======================================================
