//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-9 : External incompressible flow
//Example: 9.9   Page:473
//Topic: Lift of a spinning ball 
//================================================================
model Ex9_9

//=======================================================
//Parameter Section
parameter Real w(unit="rev/min")=7500"Topspin rotations of ball";
parameter Real d(unit="m")=0.064"Diameter of ball ";
parameter Real v(unit="m/s")=25"Speed of the ball";
parameter Real kv(unit="m^2/s")=1.46E-5"Kinematic viscosity";
parameter Real cL(unit="")=0.3"Value of cL for corresponding value of Spin ratio (WD/2V)";
parameter Real p(unit="kg/m^3")=1.23"Density of air";
parameter Real c1(unit="N*s^2/(kg*m)")=1"Unit Converison constant";
parameter Real g(unit="m/s^2")=9.81"Acceleration due to gravity";
parameter Real m(unit="kg")=0.057"Mass of ball";
parameter Real c2(unit="rad/rev")=2"Unit conversion constant";
parameter Real c3(unit="min/s")=1/60"Unit conversion constant";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=======================================================
//Variable Section
Real re(unit="")"Reynolds number";
Real fl(unit="N")"Force due to top spin";
Real rs(unit="m")"Radius of curvature of path considering top spin";
Real rws(unit="m")"Radius of curvature of path without considering top spin";
Real sr(unit="")"Spin Ratio";

//=======================================================
//Equation Section
equation
sr=w*d*c2*c3*pi/(2*v)"Expression for spin ratio";
fl=0.125*pi*cL*d^2*p*v^2*c1"Expression for fl ";
re=v*d/kv"Expression for reynolds number";
rs=v^2/(g+(fl/(m*c1)))"Expresion for Radius of curvature of path considering top spin ";
rws=v^2/g"Radius of curvature of path without considering top spin";
end Ex9_9;
//============================================================
