//Bhatt B. I. and Vora S. M., Stoichiometry, 5th Edn., McGraw Hill Higher Education 2010
//Chapter-2: Basic Chemical Calculations
//Example: 2.19 Page 27
//Title: Molarity of solution
//===============================================
model Ex2_19

//==============================================
//Parameter section
parameter Real Tmass(unit = "kg") = 100 "Mass of TEA solution (basis) " ;
parameter Real m(unit = "kg") = 50 "Mass of Triethanolamine in TEA solution" ;
parameter Real d(unit = "kg/L") = 1.05 "Density of TEA solution" ;

//==============================================
//Variable section
Real n(unit = "kmol") "Moles of TEA in solution" ;
Real V(unit = "L") "Volume of 100kg of solution" ;
Real M(unit = "mol/L") "Molarity of the solution" ;

//==============================================
//Equation section
equation
n = m/149 ;
V = Tmass/d ;
M = n*1000/V ;

//Molar mass of TEA is 149 kg/kmol
//n is multiplied with 1000 to convert kmol to mol 
end Ex2_19;
//==============================================