//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education 2010
//Chapter-2: Basic Chemical Calculations
//Example: 2.23 Page 39
//Title: Composition of petroleum refinery gas
//=============================================================================
package Ex2_23

 //=============================================================
 function mass_composition

 //========================================================
 //Variable Section
 output Real m1(unit = "kg") "Mass of Methane" ;
 output Real m2(unit = "kg") "Mass of Ethane" ;
 output Real m3(unit = "kg") "Mass of Ethylene" ;
 output Real m4(unit = "kg") "Mass of Propane" ;
 output Real m5(unit = "kg") "Mass of Propylene" ;
 output Real m6(unit = "kg") "Mass of n-Butane" ; 

 //========================================================
 //Parameter Section
 //Note:Volume percent = Mole percent
 protected
 parameter Real Tmole(unit = "kmol") = 100 "Basis of cracked petroleum refinery gas" ;
 parameter Real n1(unit = "kmol") = 45 "Moles of Methane in 100 kmol of gas mixture" ;
 parameter Real n2(unit = "kmol") = 10 "Moles of Ethane in 100 kmol of gas mixture" ;
 parameter Real n3(unit = "kmol") = 25 "Moles of Ethylene in 100 kmol of gas mixture" ;
 parameter Real n4(unit = "kmol") = 7 "Moles of Propane in 100 kmol of gas mixture" ;
 parameter Real n5(unit = "kmol") = 8 "Moles of Propylene in 100 kmol of gas mixture" ;
 parameter Real n6(unit = "kmol") = 5 "Moles of n-Butane in 100 kmol of gas mixture" ;
 parameter Real M1(unit = "kg/kmol") = 16 "Molar mass of Methane" ;
 parameter Real M2(unit = "kg/kmol") = 30 "Molar mass of Ethane" ;
 parameter Real M3(unit = "kg/kmol") = 28 "Molar mass of Ethylene" ;
 parameter Real M4(unit = "kg/kmol") = 44 "Molar mass of Propane" ;
 parameter Real M5(unit = "kg/kmol") = 42 "Molar mass of Propylene" ;
 parameter Real M6(unit = "kg/kmol") = 58 "Molar mass of n-Butane" ;

 //========================================================
 //Algorithm Section
 algorithm
 m1 := n1*M1 ;
 m2 := n2*M2 ;
 m3 := n3*M3 ;
 m4 := n4*M4 ;
 m5 := n5*M5 ;
 m6 := n6*M6 ;

 end mass_composition ;
 //============================================================

//============================================================
model Ex2_23_a
/*Average molar mass of gas mixture*/

//==========================================
//Variable Section
Real m1(unit = "kg") "Mass of Methane" ;
Real m2(unit = "kg") "Mass of Ethane" ;
Real m3(unit = "kg") "Mass of Ethylene" ;
Real m4(unit = "kg") "Mass of Propane" ;
Real m5(unit = "kg") "Mass of Propylene" ;
Real m6(unit = "kg") "Mass of n-Butane" ; 
Real M(unit = "kg/kmol") "Average molar mass of gas mixture" ;

//==========================================
//Parameter Section
parameter Real Tmole(unit = "kmol") = 100 "Basis of cracked petroleum refinery gas" ;

//===========================================
//Equation Section
equation
(m1, m2, m3, m4, m5, m6) = mass_composition() ;
M = (m1+m2+m3+m4+m5+m6)/Tmole ;

end Ex2_23_a;
//==========================================================

//==========================================================
model Ex2_23_b
/*Mass composition of gas mixture*/
//===========================================

//Variable Section
Real m1(unit = "kg") "Mass of Methane" ;
Real m2(unit = "kg") "Mass of Ethane" ;
Real m3(unit = "kg") "Mass of Ethylene" ;
Real m4(unit = "kg") "Mass of Propane" ;
Real m5(unit = "kg") "Mass of Propylene" ;
Real m6(unit = "kg") "Mass of n-Butane" ; 

//===========================================
//Equation Section
equation
(m1, m2, m3, m4, m5, m6) = mass_composition() ;

end Ex2_23_b;
//============================================

//============================================
model Ex2_23_c
/*Specific gravity of gas mixture*/

//============================================
//Variable Section
Real m1(unit = "kg") "Mass of Methane" ;
Real m2(unit = "kg") "Mass of Ethane" ;
Real m3(unit = "kg") "Mass of Ethylene" ;
Real m4(unit = "kg") "Mass of Propane" ;
Real m5(unit = "kg") "Mass of Propylene" ;
Real m6(unit = "kg") "Mass of n-Butane" ; 
Real sp "specific gravity of gas mixture"  ;
Real M(unit = "kg/kmol") "Average molar mass of gas" ;

//=============================================
//Parameter Section
parameter Real Tmole(unit = "kmol") = 100 "Basis of cracked petroleum refinery gas" ;

//=============================================
//Equation Section
equation
(m1, m2, m3, m4, m5, m6) = mass_composition() ;
M = (m1+m2+m3+m4+m5+m6)/Tmole ;
sp = M/28.97 ;

//Note:28.97 is avearge molar mass of air

end Ex2_23_c;
//=============================================

end Ex2_23;
//========================================================
