//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education 2010
//Chapter-2: Basic Chemical Calculations
//Example: 2.24 Page 40
//Title: Percentage error
//=======================================================
package Ex2_24

//====================================================
model Ex2_24_a

//====================================================
//Parameter Section
parameter Real p(unit = "bar") = 100 "Absolute pressure of superheated steam" ;
parameter Real T(unit = "K") = 623.15 "Temperature of superheated steam" ;
parameter Real Vact(unit = "m3/kg") = 0.02242 "Actual specific volume of steam at given p and T" ;
parameter Real Mw(unit = "kg/kmol") = 18.0153 "Molar mass of steam(water)" ;
parameter Real R(unit = "(kPa*m3)/(kmol*K)") = 8.314 "Gas constant" ;

//====================================================
//Variable Section
Real V(unit = "m3/kmol") "Molar volume of steam" ;
Real v(unit = "m3/kg") "Specific volume of steam" ;
Real Perr "Percentage error" ;

//====================================================
//Equation Section
equation
(p*100)*V = R*T ;//Ideal gas law 
v = V/Mw ;
Perr = (v-Vact)/Vact *100 ;

//Note:p is multiplied with 100 to convert bar to kPa

end  Ex2_24_a;
//====================================================

//====================================================
model Ex2_24_b

//====================================================
//Parameter Section
parameter Real p(unit = "bar") = 100 "Pressure of superheated steam" ;
parameter Real T(unit = "K") = 623.15 "Temperature of superheated steam" ;
parameter Real Vact(unit = "m3/kg") = 0.02242 "Actual specific volume of steam at given p and T" ;
parameter Real Mw(unit = "kg/kmol") = 18.0153 "Molar mass of steam(water)" ;
parameter Real R(unit = "(kPa*m3)/(kmol*K)") = 8.314 "Gas constant" ;
parameter Real Pc(unit = "bar") = 221.2 "Critical pressure for water" ;
parameter Real Tc(unit = "K") = 647.3 "Critical temperature for water" ;

//====================================================
//Variable Section
Real a(unit = "(m3)^2*bar/(kmol)^2 " ) "Vanderwaal's parameter";
Real b(unit = "m3/kmol") "Vanderwaal's parameter";
Real V(unit = "m3/kmol", start=0) "Molar volume of steam" ;
Real v(unit = "m3/kg") "Specific volume of steam" ;
Real Perr "Percentage error" ;

//====================================================
//Equation Section
equation
a = 27*R^2*(Tc)^2/(64*Pc) ;
b = R*Tc/(8*Pc) ;
10*V^3-5.4853*V^2+0.5524*V-0.0168 = 0 ; //Vanderwaals Equation
v = V/Mw ;
Perr = (v-Vact)/Vact *100 ;

end Ex2_24_b ;
//====================================================

end Ex2_24;
//=================================================================
