//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education 2010
//Chapter-2: Basic Chemical Calculations
//Example: 2.26 Page 43
//Title: Ternary mixture analysis
//=======================================================                           
model Ex2_26

//=======================================================
//Parameter Section
parameter Real T(unit = "K") = 296.4 "Temperature of saturated gases" ;
parameter Real p(unit = "kPa") = 102.5 "Total pressure of saturated gases" ;
parameter Real Pv(unit = "kPa") = 2.175 "Vapor pressure of water over KOH" ;
parameter Real m(unit = "g") = 6.5065 "Mass of sample" ;
parameter Real V(unit = "ml") = 415.1 "Volume of saturated gas collected" ;
parameter Real x1 = 0.431 "Mole fraction of n-Butane in hydrocarbon in burette" ;
parameter Real R(unit = "(Pa*m3)/(mol*K)") = 8.3145 "Gas constant" ;

//=======================================================
//Variable Section
Real n1(unit = "mol") "Moles of n-Butane" ;
Real n2(unit = "mol") "Moles of 1-Butene" ;
Real n3(unit = "mol") "Moles of Furfural" ;
Real m1 "Mass percent of n-Butane" ;
Real m2 "Mass percent of 1-Butene" ;
Real m3 "Mass percent  of Furfural" ;
Real Pa(unit = "kPa") "Partial pressure of n-Butane and 1-Butene" ;
Real n(unit = "mol") "Moles of n-Butane and 1-Butene" ;
Real mp1 "Mole percent of n-Butane" ;
Real mp2 "Mole percent of 1-Butene" ;
Real mp3 "Mole percent of Furfural" ;

//=======================================================
//Equation Section
equation
Pa = p-Pv ;
(Pa*1000)*(V*10^(-6)) = n*R*T ;
n1 = x1*n;
m1 = n1*58/m*100 ;
n2 = n-n1 ;
m2 = n2*56/m*100 ;
m3 =100-m1-m2;
n3 = m3*m/96/100 ;
mp1 = n1/(n1+n2+n3)*100 ;
mp2 = n2/(n1+n2+n3)*100 ;
mp3 = n3/(n1+n2+n3)*100 ;

//Pressure Pa is multiplied with 1000 to convert kpa to Pa 
//V is multiplied with 10^(-6) to convert ml to m3
//Molar mass of n-Butane 58 g/mol
//Molar mass of 1-Butene 56 g/mol
//Molar mass of Furfural 96 g/mol

end Ex2_26;
//=======================================================
