//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education 2010
//Chapter-2: Basic Chemical Calculations
//Example: 2.7 Page 20
//Title: Composition of mixture
//===================================================
package Ex2_7

//===================================================
model Ex2_7_a
/* Mass % */

//===================================================
//Parameter Section
parameter Real m1(unit = "kg") = 600 "Mass of NaCl" ;
parameter Real m2(unit = "kg") = 200 "Mass of KCl" ;

//===================================================
//Variable Section
Real m(unit = "kg") "Total mass" ;
Real w1 "Mass percent of NaCl" ;
Real w2 "Mass percent of KCl"; 

//===================================================
//Equation Section
equation
m = m1+m2 ;
w1 = m1/m*100 ;
w2 = 100-w1 ;

end Ex2_7_a ;
//===================================================

//===================================================
model Ex2_7_b
/* Mole % */

//===================================================
//Referance Section
extends Ex2_7_a ;

//===================================================
//Variable Section
Real M1(unit = "kg/kmol") "Molar mass of NaCl" ;
Real M2(unit = "kg/kmol") "Molar mass of KCl" ;
Real n1(unit = "kmol") "Moles of NaCl" ;
Real n2(unit = "kmol") "Moles of KCl" ;
Real n(unit = "kmol") "Total moles" ;
Real mp1 "Mole percent of NaCl" ;
Real mp2 "Mole percent of KCl" ;

//===================================================
//Equation Section
equation
M1 = 23+35.5 ;
n1 = m1/M1 ;
M2 = 39+35.5 ;
n2 = m2/M2 ;
n = n1+n2 ;
mp1 = n1/n*100 ;
mp2 = 100-mp1 ;

end Ex2_7_b ;
//===================================================

end Ex2_7;
//===================================================
