//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education
//Chapter-3: Material Balances without Chemical Reaction
//Example: 3.11 Page 68
//Title: Flow rate calculation
//=======================================================
model Ex3_11

//=======================================================
//Parameter Section
parameter Real F(unit = "kg/hr") = 1000 "Feed to distillation system" ;
parameter Real M[9,9] = {{1,0,0,1,0,0,1,0,0}, {0,1,0,0,1,0,0,1,0},{0,0,1,0,0,1,0,0,1},{1,0,0,0,0,0,0,0,0},{0,1,0,0,0,0,0,0,0},{0,0,1,0,0,0,0,0,0},{0,0,0,1,0,0,0,0,0},{0,0,0,0,1,0,0,0,0},{0,0,0,0,0,1,0,0,0}} ;
parameter Real v[9,1] = {{400},{100},{500},{4},{94},{60},{16},{6},{400}} ;

//=======================================================
//Variable Section
Real soln[9,1] ;
Real mA(unit = "kg/hr") "Mass flow rate of product stream A" ;
Real mB(unit = "kg/hr") "Mass flow rate of product stream B" ;
Real mC(unit = "kg/hr") "Mass flow rate of product stream C" ;

//=======================================================
//Equation XSection
equation
//Fractional recovery of component i in the fraction j(fRij) = (mass of i in fraction j)/(mass of i fed to column)
//Material balance equations
//Balance of H2SO4
//mS,A + mS,B +mS,C = mS,F
//Balance of HNO3
//mN,A + mN,B +mN,C = mN,F
//Balance of H2O
//mW,A + mW,B +mW,C = mW,F
//mS,A = fRSA*Ms,F
//mN,A = fRNA*mN,F
//mW,A = fRWA*mW,F
//mS,B = fRSB*mS,F
//mN,B = fRNB*mN,F
//mW,B = fRWB*mW,F
M*soln = v ;
mA = soln[1,1]+soln[2,1]+soln[3,1] ;
mB = soln[4,1]+soln[5,1]+soln[6,1] ;
mC = soln[7,1]+soln[8,1]+soln[9,1] ;

end Ex3_11;
//=======================================================
