//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-3: Material Balances without Chemical Reaction
//Example: 3.17 Page 79
//Title: 2 stage membrane separation of CO

//=======================================================
package Ex3_17

  //=======================================================
  model Ex3_17_a
  //Flow rates of product CO stream

  //=======================================================
  //Parameter Section
  parameter Real F(unit = "kmol/hr") = 5000 "Fresh feed rate" ;
  parameter Real xco = 0.47 "Mole fraction of CO in feed" ;
  parameter Real recovery = 0.932 "Recovery of CO " ;
  parameter Real purity = 0.98 "Purity of CO in product" ;
  
  //=======================================================
  //Variable Section
  Real FCO(unit = "kmol/hr") "CO in feed" ;
  Real PCO(unit = "kmol/hr") "CO in product CO stream" ;
  Real n2(unit = "kmol/hr") "CO Product stream" ;
  Real PH2(unit = "kmol/hr") "H2 in product CO stream" ;
  
  //=======================================================
  //Equation Section
  equation 
  FCO = F*xco ;
  PCO = FCO*recovery ;
  n2 = PCO/purity ;
  PH2 = n2-PCO ;
  
  end Ex3_17_a ;
  //=======================================================
  
  //=======================================================
  model Ex3_17_b
  //Composition of product hydrogen stream
  
  //=======================================================
  extends Ex3_17_a ;
  
  //=======================================================
  //Variable Section
  Real nH1(unit = "kmol/hr") "H2 in product H2 stream" ;
  Real nH(unit = "kmol/hr") "CO in product H2 stream" ;
  Real xH1 "Percentage of H2 in product H2 stream" ;
  Real xCO1 "Percentage of CO in product H2 stream" ;
  
  //=======================================================
  //Equation Section
  equation
  nH1 = (F-FCO)-PH2 ;
  nH = FCO-PCO ;
  xH1 = nH1/(nH1+nH)*100 ;
  xCO1 = 100-xH1 ;
  
  end Ex3_17_b ;
  //=======================================================
  
  //=======================================================
  model Ex3_17_c
  //Composition of mixed feed
  
  extends Ex3_17_a ;
  extends Ex3_17_b ;
  
  //=======================================================
  //Parameter Section
  parameter Real R(unit = "kmol/hr") = 3000 "Recycle stream" ;
  parameter Real mr = 1.1 "Mole ratio of H2/CO in feed to II stage" ;
  
  //======================================================= 
  //Variable Section
  Real nH2(unit = "kmol/hr") "H2 in recycle stream" ;
  Real nCO(unit = "kmol/hr") "CO in recycle stream" ;
  Real xH2 "Mole percent of H2 in mixed feed" ;
  Real xCO "Mole percent of CO in mixed feed" ;
  
  //=======================================================
  //Equation Section 
  equation
  nH2+nCO = R ;
  (PH2+nH2)/(PCO+nCO) = mr ;
  xCO = (FCO+nCO)/((FCO+nCO)+((F-FCO)+nH2))*100 ;
  xH2 = 100 - xCO ;
  
  end Ex3_17_c ;
end Ex3_17;
