//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-3: Material Balances without Chemical Reaction
//Example: 3.18 Page 81
//Title: 2 stage RO plant

//=======================================================
model Ex3_18

//=======================================================
//Parameter Section
parameter Real P2(unit = "m3/hr") = 5 "Product from module II" ;
parameter Real xF(unit = "mg/L") = 4200 "DS in fresh feed" ;
parameter Real xP2(unit = "mg/L") = 5 "DS in product from module II" ;
parameter Real re = 0.985 "Rejection of salt in module II" ;

//=======================================================
//Variable Section
Real F(unit = "m3/hr") "Fresh feed to plant" ;
Real R1(unit = "m3/hr") "Reject from module I" ;
Real P1(unit = "m3/hr") "Product from module I" ;
Real R2(unit = "m3/hr") "Recycle from module II" ;
Real xR1(unit = "mg/L") "DS in reject from module I" ;
Real xP1(unit = "mg/L") "DS in product from module I" ;
Real xR2(unit = "mg/L") "DS in recovery from module II" ;
Real MF(unit = "g/hr") "DS in mixed feed" ;
Real perxR1(unit = "mg/l") "percent of DS in reject stream from module I" ;
Real c1(unit = "mg/L") "Concentration of DS in mixed feed" ;
Real m1(unit = "g/hr") "DS in R1" ;
Real m2(unit = "g/hr") "DS in P1" ;
//Real c2(unit = "mg/L") "Concentration of DS in P1" ;
Real R "Recycle ratio in  m3 reject recycle/m3 fresh feed" ;
Real OR "Overall recovery" ;

//=======================================================
//Material balance section
//Overall Balance: F=R1+P2
//Balance across module I: F+R2=R1+P1 => P1=P2+R2
//Balance of DS: F*(xF)=R1*(xR1)+P2*(xP2)
 
//=======================================================
//Equation Section
equation
P2/P1 = 0.8 ;
R2 = P1-P2 ;
P1/(F+R2) = 0.66 ;
R1 = F-P2 ;
F*(xF)=R1*(xR1)+P2*(xP2) ;
xP1 = P2*xP2/(1-re)/P1 ;
P1*(xP1) = P2*(xP2)+R2*(xR2) ;
MF = F*(xF)+R2*(xR2) ;
c1 = MF/(F+R2) ;
m1 = (R1*xR1) ;
perxR1 = m1/MF*100 ;
m2 = MF-m1 ;
//c2 = m2/P1 check
R = R2/F ;
OR = P2/F*100 ;

end Ex3_18;
//=======================================================