//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education
//Chapter-3: Material Balances without Chemical Reaction
//Example: 3.4 Page 62
//Title: Extraction
//=======================================================
package Ex3_4

//=======================================================
model Ex3_4_a

/*Mass of extract phase per kg of dry neem leaves */
//=======================================================
//Parameter Section
parameter Real m(unit = "kg") = 1 "Basis for mass of dry neem leaves" ;
parameter Real m1(unit = "kg") = 0.0046 "Mass of alpha-tocopherol in feed" ;
parameter Real m2(unit = "kg") = 0.0001 "Mass of beta-carotene in feed" ;
parameter Real E1 = 15.5 "Mass percent of alpha-tocopherol in extract" ;
parameter Real E2 = 0.41 "Mass percent of beta-carotene in extract" ;

//=======================================================
//Variable Section
Real E(unit = "kg") "Mass of extract" ;

//=======================================================
//Equation Section
equation
E*E2/100 = m2 ;

end Ex3_4_a ;
//=======================================================

//=======================================================
model Ex3_4_b

/* % Recovery of Alpha-Tocopherol */
//=======================================================
extends Ex3_4_a ;

//=======================================================
//Variable Section
Real M1(unit = "kg") "Mass of Alpha-Tocopherol in extract" ;
Real R "Percentage of Alpha-Tocopherol recovered" ;

//=======================================================
//Equation Section
equation
M1 = E1/100*E ;
R = M1/m1*100 ;

end Ex3_4_b ;
//=======================================================

end Ex3_4;
//=======================================================
