//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education
//Chapter-3: Material Balances without Chemical Reaction
//Example: 3.8 Page 64
//Title: Mixed acid
//=======================================================
model Ex3_8

//=======================================================
//Parameter Section
parameter Real M(unit = "kg") = 1000 "Mass of mixed acid feed" ;
parameter Real m1(unit = "kg") = 600 "Mass of H2SO4 in feed" ;
parameter Real m2(unit = "kg") = 320 "Mass of HNO3 in feed" ;
parameter Real m3(unit = "kg") = 80 "Mass of water in feed" ;
parameter Real S1 = 11.3 "Mass percent of HNO3 in spent acid" ;
parameter Real S2 = 44.4 "Mass percent of H2SO4 in spent acid" ;
parameter Real S3 = 44.6 "Mass percent of H2O in spent acid" ;
parameter Real A1 = 90 "Mass percent of HNO3 in aqueous nitric acid" ;
parameter Real A2 = 98 "Mass percent of H2SO4 in sulphuric acid" ;

//=======================================================
//Variable Section
Real x(unit = "kg") "Quantity of spent acid" ;
Real y(unit = "kg") "Quantity of Aqueous nitric acid" ;
Real z(unit = "kg") "Quantity of Aqueous sulphuric acid" ;

//=======================================================
//Equation Section
equation
x+y+z = M ;//Overall material balance
S2/100*x+A2/100*z = m1 ;//Balance of sulphuric acid
S1/100*x+A1/100*y = m2 ;//Balance of nitric acid

end Ex3_8;
//=======================================================