//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-4: Material Balances involving Chemical Reactions
//Example: 4.12 Page 136
//Title: Burning of pyrites and zinc sulphide

//=======================================================
package Ex4_12

//=======================================================
model Ex4_12_a
/* Cinder formed */

//=======================================================
//Parameter Section
parameter Real m(unit = "kg") = 100 "Basis of mixed charge" ;
parameter Real m1(unit = "kg") = 75 "Pyrites in feed" ;
parameter Real m2(unit = "kg") = 25 "Zinc sulphide in feed" ;
parameter Real x1(unit = "kg") = 0.92 "Mass fraction of FeS2 in pyrites" ;
parameter Real x2(unit = "kg") = 0.68 "Mass fraction of ZnS in zinc sulphide ore" ;
parameter Real cinder(unit = "kg") = 100 "Basis for cinder" ;
parameter Real m6(unit = "kg") = 3.5 "S in cinder" ;
parameter Real x3 = 70 "Percent of S in cinder in form of SO3" ;

//=======================================================
//Variable Section
Real Gangue(unit = "kg") "Mass of gangue in pyrites" ;
Real Inert(unit = "kg") "Inerts in zinc sulphide ore" ;
Real m3(unit = "kg") "FeS2 in pyrites" ;
Real m4(unit = "kg") "ZnS in zinc sulphide ore" ;
Real T(unit = "kg") "Total inerts" ;
Real m5(unit = "kg") "S in form of SO3 in cinder"; 
Real m7(unit = "kg") "SO3 in cinder" ;
Real m8(unit = "kg") "FeS2 in cinder" ;
Real m9(unit = "kg") "S compound-free cinder" ;
Real m10(unit = "kg") "ZnO produced" ;
Real m11(unit = "kg") "Fe2O3 produced" ;
Real x(unit = "kg",start = 0) "FeS2 reacted" ; 
Real m12(unit = "kg") "S-free cinder" ;
Real m13(unit = "kg") "FeS2 in cinder" ;
Real m14(unit = "kg") "S as SO3 in cinder" ;

//=======================================================
//Equation Section
equation
m3 = m1*x1 ;
m4 = m2*x2 ;
Gangue = m1-m3 ;
Inert = m2-m4 ;
T = Gangue+Inert ;
m5 = m6*x3/100 ;
m7 = m5/32*80 ;
m8 = (120/64)*(m6-m5) ;
m9 = cinder-(m7+m8) ;
m10 = (81.4/97.4)*m4 ;
(69-x)/(m10+T+m11) = m8/m9 ;
m11 = x*160/120/2 ;
m12 = m10+m11+T ;
m13 = m3-x ;
m14 = m7/m9*m12 ;

end Ex4_12_a ;
//=======================================================

//=======================================================
model Ex4_12_b 
/* Percent of S in cinder */

//=======================================================
//Parameter Section
parameter Real m1(unit = "kg") = 69 "FeS2 in pyrites"  ;
parameter Real m2(unit = "kg") = 17 "ZnS in zinc sulphide ore" ;
parameter Real m3(unit = "kg") = 79.63 "Total cinder" ;
 
//=======================================================
//Variable Section
Real m4(unit = "kg") "S charged to burner" ;
Real m5(unit = "kg") "S in cinder" ;
Real p "Percent of S left in cinder" ;

//=======================================================
//Equation Section
equation
m4 = (64/120)*m1+(32/97.4)*m2 ;
m5 = 0.035*m3 ;
p = m5/m4*100 ;

end Ex4_12_b ;
//=======================================================

end Ex4_12;
//=======================================================
