//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-4: Material Balances involving Chemical Reactions
//Example: 4.13 Page 138
//Title: pH raising with NaOH 

//=======================================================
model Ex4_13

//=======================================================
//Parameter Section
parameter Real V(unit = "L") = 1200 "Volume of reactants" ;
parameter Real d1(unit = "kg/L") = 1.2 "Density of reactants" ;
parameter Real d2(unit = "kg/L") = 1.005 "Density of NaOH soln" ;
parameter Real pH1 = 6 "pH of reaction mass" ;
parameter Real pH2 = 9 "pH of final mass" ;

//=======================================================
//Variable Section
Real m(unit = "kg") "Mass of reactants" ;
Real pOH1 "pOH of reaction mass" ;
Real pOH2 "pOH of resulting mass" ;
Real pOH3 "pOH of 0.5% NaOH soln" ;
Real ms(unit = "g",start = 0) "Mass of 0.5% NaOH solution required to raise the pH" ;
Real ds(unit = "kg/L",start = 0) "Density of resulting solution" ;

//=======================================================
//Equation Section
equation
m = V*d1 ;
pOH1 = 14-pH1 ;
pOH2 = 14-pH2 ;
pOH3 = 14-12.85 ;
ds = 1/((m*1000/(m*1000+ms)/d1)+(ms/(m*1000+ms)/d2)) ;
V*10^(-pOH1)+(ms/(d2*1000))*10^(-pOH3) = (V*d1*1000+ms)/(ds*1000)*10^(-pOH2) ;

//Note: pH of 0.5% NaOH soln is 12.85, Ref. Fig. 2.2

end Ex4_13;
//=======================================================