//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-4: Material Balances involving Chemical Reactions
//Example: 4.18 Page 149
//Title: Additional membrane separator in Ex4_17 

//=======================================================
model Ex4_18

//=======================================================
//Parameter Section
parameter Real H2_rec = 0.9 "Overall H2 recovery" ;

//=======================================================
//Variable Section
Real H2_P(unit = "kmol/s") "H2 in purge" ;
Real a(unit = "kmol/s",start = 95) "N2 in mixed feed" ;
Real M(unit = "kmol/s",start = 450) "Mixed feed" ;
Real P(unit = "kmol/s",start = 1) "Purge stream" ;
Real R1(unit = "kmol/s") "Recycle stream" ;
Real R2(unit = "kmol/s") "H2 recovered from membrane" ;
Real R2_I(unit = "kmol/s") "Inerts in R2" ;

//=======================================================
//Equation Section
equation
H2_P = 2.25*a*P/(0.415*M+1.775*a) ;                             //Ref. Fig. 4.3
R2 = H2_P*H2_rec/H2_rec ;
R2_I = 0.05*R2 ;
0.1*M*P/(0.415*M+1.775*a) - R2_I = 1 ;                          //Inerts in reject from membrane
(0.315*M-1.225*a)*R1/(0.415*M+1.775*a) = 0.9*M-4*a ;            //Ammonia balance
M = 100+R1+R2 ;                                                 //Overall material balance
//Inerts balance in loop
0.1*M*R1/(0.415*M+1.775*a)+0.1125*a*P/(0.415*M+1.775*a)+1 = 0.1*M ;

end Ex4_18;