//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-4: Material Balances involving Chemical Reactions
//Example: 4.19 Page 153
//Title: Partial demineralisation plant 

//=======================================================
model Ex4_19

//=======================================================
//Parameter Section
parameter Real Cl(unit = "mg/L") = 312 "Chloride as Cl in raw water" ;
parameter Real SO4(unit = "mg/L") = 43.2 "Sulphates as SO4 in raw water" ;
parameter Real M1(unit = "mg/L") = 550 "Total alkalinity as CaCO3 in raw water" ;
parameter Real M2(unit = "mg/l") = 50 " Total alkalinity as CaCO3 in effluent from ion exchangers" ;
parameter Real V(unit = "L") = 100 "Total raw water inlet" ; 

//=======================================================
//Variable Section
Real m1(unit = "mg/L") "Cl expressed as equivalent CaCO3" ;
Real m2(unit = "mg/L") "SO4 expressed as equivalent CaCO3" ;
Real A(unit = "mg/L") "Equivalent mineral acidity in CaCO3" ;
Real x "Percent of raw water to hydrogen ion exchanger" ;

//=======================================================
//Equation Section
equation
m1 = (50/35.5)*Cl ;
m2 = (50/48)*SO4 ;
A = m1+m2 ;
x*(A+M1) = V*(M1-M2) ;              //Free acidity in demineralised water = Tptal alkalinity removed

end Ex4_19;
//=======================================================