//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-4: Material Balances involving Chemical Reactions
//Example: 4.20 Page 155
//Title: Capacity increment on adding a second reactor 

//=======================================================
model Ex4_20

//=======================================================
//Parameter Section
parameter Real G1(unit = "kmol/hr") = 1488.1 "Gas mixture flow rate to Reactor 1" ;
parameter Real x1 = 0.0625 "Volume fraction of MeOH at Reactor 1" ;

//=======================================================
//variable section
Real MeOH1(unit = "kmol/hr") "MeOH in gas mixture" ;
Real wet_air(unit = "kmol/hr") "Ambient wet air flow" ;
Real dry_air(unit = "kmol/hr") "Dry air flow rate" ;
Real H2O1(unit = "kmol/hr") "Moisture entering with air" ;
Real conv(unit = "kmol/hr") "Conversion of MeOH" ;
Real MeOH(unit = "kmol/hr") "MeOH reacted through reaction (ii) to (v)" ;
Real MeOH_i(unit = "kmol/hr") "MeOH reacted by rnx (i) in reactor 1" ;
Real O2_i(unit = "kmol/hr") "O2 consumed by rnx (i) in reactor 1"; 
Real HCHO(unit = "kmol/hr") "HCHO produced from rnx (i) in reactor 1" ;
Real H2O_i(unit = "kmol/hr") "Water produced by rnx (i) in reactor 1" ;
Real MeOH_ii(unit = "kmol/hr") "Methanol reacted by rnx (ii) in reactor 1" ;
Real O2_ii(unit = "kmol/hr") "O2 reacted by rnx (ii) in reactor 1" ;
Real CO2(unit = "kmol/hr") "CO2 produced by rnx (ii) in reactor 1" ;
Real H2O_ii(unit = "kmol/hr") "H2O produced by rnx (ii) in reactor 1" ;
Real MeOH_iii(unit = "kmol/hr") "Methanol reacted by rnx (iii) in reactor 1" ;
Real CO(unit = "kmol/hr") "CO produced by rnx (iii) in reactor 1" ;
Real H2(unit = "kmol/hr") "H2 produced by rnx (iii) in reactor 1" ;
Real MeOH_iv(unit = "kmol/hr") "Methanol reacted by rnx (iv) in reactor 1" ;
Real CH4(unit = "kmol/hr") "Methane produced by rnx (iv) in reactor 1" ;
Real O2_iv(unit = "kmol/hr") "O2 produced by rnx (iv) in reactor 1" ;
Real MeOH_v(unit = "kmol/hr") "MeOH reacted by reaction (v) in reactor 1" ;
Real DME(unit = "kmol/hr") "(CH3)2O produced by reaction (v) in reactor 1" ;
Real H2O_v(unit = "kmol/hr") "Water produced by reaction (v) in reactor 1" ;
Real O2(unit = "kmol/hr") "O2 exit from reactor 1" ;
Real H2O(unit = "kmol/hr") "H2O exit from reactor 1" ;
Real x(unit = "kmol/hr",start = 1) "MeOH added in between reactors" ;
Real MeOH2(unit = "kmol/hr") "MeOH entering reactor 2" ;
Real conv2(unit = "kmol/hr") "MeOH reacted in reactor 2" ;
Real MeOH2_i(unit = "kmol/hr") "MeOH reacted by rnx (i) in reactor 2" ;
Real O22_i(unit = "kmol/hr") "O2 consumed by rnx (i) in reactor 2"; 
Real HCHO2(unit = "kmol/hr") "HCHO produced from rnx (i) in reactor 2" ;
Real H2O_2i(unit = "kmol/hr") "Water produced by rnx (i) in reactor 2" ;
Real MeOH2_ii(unit = "kmol/hr") "Methanol reacted by rnx (ii) in reactor 2" ;
Real O22_ii(unit = "kmol/hr") "O2 reacted by rnx (ii) in reactor 2" ;
Real CO22(unit = "kmol/hr") "CO2 produced by rnx (ii) in reactor 2" ;
Real H2O_2ii(unit = "kmol/hr") "H2O produced by rnx (ii) in reactor 2" ;
Real MeOH3_iii(unit = "kmol/hr") "Methanol reacted by rnx (iii) in reactor 2" ;
Real CO_3(unit = "kmol/hr") "CO produced by rnx (iii) in reactor 2" ;
Real H23(unit = "kmol/hr") "H2 produced by rnx (iii) in reactor 2" ;
Real MeOH2_iv(unit = "kmol/hr") "Methanol reacted by rnx (iv) in reactor 2" ;
Real CH4_2(unit = "kmol/hr") "Methane produced by rnx (iv) in reactor 2" ;
Real O22_iv(unit = "kmol/hr") "O2 produced by rnx (iv) in reactor 2" ;
Real MeOH2_v(unit = "kmol/hr") "MeOH reacted by reaction (v) in reactor 2" ;
Real DME2(unit = "kmol/hr") "(CH3)2O produced by reaction (v) in reactor 2" ;
Real H2O_2v(unit = "kmol/hr") "Water produced by reaction (v) in reactor 2" ;
Real Meth(unit = "kmol/hr") "MeOH reacted from rnx (ii) to (v)" ;
Real Meth_by(unit = "kmol/hr") "Mehanol bypassed" ;
Real Capacity "Increase in capacity" ;

//=======================================================
//Eqaution Section
equation
//Reactor 1
MeOH1 = G1*x1 ;
wet_air = G1-MeOH1 ;
dry_air = wet_air/1.01772 ;
H2O1 = wet_air-dry_air ;
conv = MeOH1*0.99 ;
//Reaction (i)
 MeOH_i = conv*0.9 ;
 O2_i = MeOH_i/2 ;
 HCHO = MeOH_i ;
 H2O_i = MeOH_i ;
MeOH = conv-MeOH_i ;
//Reaction (ii)
 MeOH_ii = MeOH*0.71 ;
 O2_ii = MeOH_ii*1.5 ;
 CO2 = MeOH_ii ;
 H2O_ii = MeOH_ii*2 ;
//Reaction (iii)
 MeOH_iii = MeOH*0.08 ;
 CO = MeOH_iii ;
 H2 = MeOH_iii*2 ;
//Reaction (iv)
  MeOH_iv = MeOH*0.05 ;
  CH4 = MeOH_iv ;
  O2_iv = MeOH_iv/2 ;
//Reaction ( v)
 MeOH_v = MeOH-(MeOH_ii+MeOH_iii+MeOH_iv) ;
 DME = MeOH_v/2 ;
 H2O_v = MeOH_v/2 ;
O2 = 287.87-O2_i-O2_ii+O2_iv ;
H2O = H2O1+H2O_i+H2O_ii+H2O_v ;
//Reactor 2
MeOH2 = (MeOH1-conv)+x ; 
MeOH2/(1543.714+x) = 0.084 ;
conv2 = MeOH2*0.99 ;
//Reaction (i)
 MeOH2_i = conv2*0.9 ;
 O22_i = MeOH2_i/2 ;
 HCHO2 = MeOH2_i ;
 H2O_2i = MeOH2_i ;
Meth = conv2-MeOH2_i ;
//Reaction (ii)
 MeOH2_ii = Meth*0.71 ;
 O22_ii = MeOH2_ii*1.5 ;
 CO22 = MeOH2_ii ;
 H2O_2ii = MeOH2_ii*2 ;
//Reaction (iii)
 MeOH3_iii = Meth*0.08 ;
 CO_3 = MeOH3_iii*2 ;
 H23 = MeOH3_iii*2 ;
//Reaction (iv)
  MeOH2_iv = Meth*0.05 ;
  CH4_2 = MeOH2_iv ;
  O22_iv = MeOH2_iv/2 ;
//Reaction ( v)
 MeOH2_v = Meth-(MeOH2_ii+MeOH3_iii+MeOH2_iv) ;
 DME2 = MeOH2_v/2 ;
 H2O_2v = MeOH2_v/2 ;
Meth_by = x/(x+MeOH1)*100 ;
Capacity = ((92.07+HCHO2)*30/0.37-9030.4)/9030.4*100 ;

end Ex4_20;
//=======================================================