//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-4: Material Balances involving Chemical Reactions
//Example: 4.4 Page 119
//Title: Manufacturing of Acetaldehyde

//=======================================================
package Ex4_4

//=======================================================
model Ex4_4_a
/* Conversion of ethanol */

//=======================================================
//Parameter Section
parameter Real n(unit = "kmol") = 100 "Outgoing gas from 2nd scrubber" ;
parameter Real n1(unit = "kmol") = 0.7 "Moles of CO2 in outgoing gas" ;
parameter Real n2(unit = "kmol") = 2.1 "Moles of O2 in outgoing gas" ;
parameter Real n3(unit = "kmol") = 2.3 "Moles of CO in outgoing gas" ;
parameter Real n4(unit = "kmol") = 7.1 "Moles of H2 in outgoing gas" ;
parameter Real n5(unit = "kmol") = 2.6 "Moles of CH4 in outgoing gas" ;
parameter Real n6(unit = "kmol") = 85.2 "Moles of N2 in outgoing gas" ;

//=======================================================
//Variable Section
Real N1(unit = "kmol") "O2 supplied through air" ;
Real O2_react(unit = "kmol") "O2 reacted" ;
Real a(unit = "kmol") "Ethanol reacted by reaction (ii)" ;
Real b(unit = "kmol") "Ethanol reacted by reaction (iii)" ;
Real c(unit = "kmol") "Ethanol reacted by reaction (iv)" ;
Real d(unit = "kmol") "H2 reacted by reaction (v)" ;
Real N2(unit = "kmol") "Total H2 produced" ;
Real N3(unit = "kmol") "H2 produced by (i)" ;
Real N4(unit = "kg") "Total ethanol reacted" ;
Real N5(unit = "kg") "Total dry air entering converter" ;
Real N6(unit = "kg") "Total ethanol entering converter" ;
Real conversion "Conversion of ethanol" ;

//=======================================================
//Equation Section
equation
N1 = 21/79*n6 ;
O2_react = N1-n2 ;
a+3*b-c+d = 2*O2_react ; //O2 balance
2*a = n3 ; //CO balance
2*b = n1 ; //CO2 balance 
2*c = n5 ; //CH4 balance
N2 = n4+c+d ; //H2 in outgoing gas + H2 reacted in (v) + H2 reacted in (iv) 
              //H2 produced by (i), (ii) ,(iii)
N3 = N2-(3*b+3*a) ; //H2 produced by (i) = ethanol reacted by (i)
N4 = (N3+a+b+c)*46 ;
N5 = (n6+N1)*29 ;
N6 = 2*N5 ;
conversion = N4/N6*100 ;

//Note:N2 remains unchanged during reaction
//For 79 kmol of N2, 21 kmol of O2 enters the converter              
end Ex4_4_a ;
//======================================================= 

//=======================================================
model Ex4_4_b 
/* Yield */

//=======================================================
//Reefernce Section
extends Ex4_4_a ;

//=======================================================
//Variable Section
Real N7(unit = "kmol") "Moles of acetaldehyde product" ;
Real N8(unit = "kmol") "Moles of Ethanol reacted" ;
Real yield_A "Yield of acetaldehyde" ;
Real selectivity_A "Selectivity of acetaldehyde" ;

//=======================================================
//Equation Section
equation
N7 = N3 ; //Moles of H2 produced by reaction (i) = Moles of acetaldehyde produced
N8 = N4/46 ;
yield_A = N7*1/N8*100 ;
selectivity_A = N7/(N8-N7) ;

end Ex4_4_b ;
//=======================================================

end Ex4_4;
