//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.11 Page 225
//Title: Latent heat of vapourisation of EtOH

//=======================================================
package Ex5_11

//=======================================================
model Ex5_11_a
/* Using Reidel equation and NIST */

//=======================================================
//Parameter Section
parameter Real Pc(unit = "bar") = 61.37 "Critical pressure of EtOH" ;
parameter Real Tc(unit = "K") = 514 "Critical pressure of EtOH" ;
parameter Real Tb(unit = "K") = 351.4 "Boiling point of EtOH" ;

//=======================================================
//Variable Section
Real Tbr(unit = "K") "Reduced temperature" ;
Real Lambda1(unit = "kJ/kmol") "Latent heat of vapourisation of EtOH at Tb using Reidel eqn" ;
Real Lambda2(unit = "kJ/kmol") "Latent heat of vapourisation of EtOH at Tb using NIST eqn" ;

//=======================================================
//Equation Section
equation
Tbr = Tb/Tc ;
Lambda1 = 8.314472*Tb*1.092*(log(Pc*100)-5.6182)/(0.930-Tbr) ; //Reidel eqn
Lambda2 = 50430*exp(-(-0.4475*Tbr))*(1-Tbr)^(0.4989) ;         //NIST eqn

end Ex5_11_a ;
//=======================================================

//=======================================================
model Ex5_11_b
/*Using Watson and NIST eqn */

//=======================================================
//Parameter Section
parameter Real T1(unit = "K") = 298.15 "Temperature" ;
parameter Real Tc(unit = "K") = 514 "Critical pressure of EtOH" ;

//=======================================================
//Variable Section
Real Tbr(unit = "K") "Reduced temperature" ;
Real Lambda1(unit = "kJ/kmol") "Latent heat of vapourisation at T1 using Watson eqn" ;
Real Lambda2(unit = "kJ/kmol") "Latent heat of vapourisation at T1 using NIST eqn" ; 

//=======================================================
//Equation Section
equation
Tbr = T1/Tc ;
Lambda1 = 38563*((Tc-T1)/(Tc-351.4))^(0.38) ;                 //Watson eqn
Lambda2 = 50430*exp(-(-0.4475*Tbr))*(1-Tbr)^(0.4969) ;        //NIST eqn

end Ex5_11_b ;
//=======================================================

end Ex5_11;
//=======================================================
