//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.14 Page 237
//Title: Hot air drying machine(stenter)

//=======================================================
model Ex5_14

//=======================================================
//Parameter Section
parameter Real m(unit = "kg/hr") = 1000 "Condensate at saturation temperature corresponding to 8 bar" ;
parameter Real P(unit = "bar") = 8 "Steam pressure" ;
parameter Real H1(unit = "kJ/kg") = 720.94 "Enthalpy of condensate before steam trap" ;
parameter Real H2(unit = "kJ/kg") = 419.06 "Enthalpy of condensate after discharge to atm pressure" ;

//=======================================================
//Variable section
Real x(unit = "kg") "Flash steam produced" ;
Real T1(unit = "kJ/hr") "Total heat of condensate before flashing" ;
Real T2(unit = "kK/hr") "Total heat of condensate after flashing" ;
Real T3(unit = "kJ/hr") "Total heat of flash steam" ;

//=======================================================
//Equation Section 
equation
T1 = m*H1 ;
T2 = (m-x)*H2 ;
T3 = x*2676 ;
T3+T2 = T1 ;

//Note: Steam table Ref. Appendix IV.2

end Ex5_14;
//=======================================================