//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.18 Page 243
//Title: Steam accumulator

//=======================================================
model Ex5_18

//=======================================================
//Parameter Section
parameter Real V(unit = "m^3") = 45 "Volume of accumulator" ; 
parameter Real x = 0.85 "Fraction of water at 6 bar g" ;
parameter Real Ta(unit = "K")= 300 "Surrounding temperature" ;

//=======================================================
//Variable Section
Real v1(unit = "m^3") "Volume of water in accumulator at 6 bar g" ;
Real v2(unit = "m^3") "Volume of steam in accumulator at 6 bar g" ;
Real w(unit = "kg") "Weight of fluid in accumulator" ;
Real H1(unit = "kJ") "Total thermal energy accumulated in accumulator at 6 bar g" ;
Real x1(unit = "kg") "Mass of steam at 436 K" ;
Real m1(unit = "kg") "Mass of water in accumulator at 436 K" ;
Real H2(unit = "kJ") "Total thermal energy accumulated in accumulator at 436 K" ;
Real delta_H1(unit = "kJ") "Loss in enthalpy between 438.2 and 436 K" ;
Real x2(unit = "kg") "Mass of steam at 434 K" ;
Real m2(unit = "kg") "Mass of water in accumulator at 434 K" ;
Real H3(unit = "kJ") "Total thermal energy accumulated in accumulator at 434 K" ;
Real delta_H2(unit = "kJ") "Loss in enthalpy between 436 and 434 K" ;
Real x3(unit = "kg") "Mass of steam at 432.1 K" ;
Real m3(unit = "kg") "Mass of water in accumulator at 432.1 K" ;
Real H4(unit = "kJ") "Total thermal energy accumulated in accumulator at 432.1 K" ;
Real delta_H3(unit = "kJ") "Loss in enthalpy between 434 and 432.1 K" ;
Real Ts1(unit = "K") "Average steam temperature between 438.2K and 436 K" ;
Real Q1(unit = "kJ/hr") "Heat transfer" ;
Real t1(unit = "hr") "Time for heat transfer" ;
Real Ts2(unit = "K") "Average steam temperature between 436 K and 434 K" ;
Real Q2(unit = "kJ/hr") "Heat transfer" ;
Real t2(unit = "hr") "Time for heat transfer" ;
Real Ts3(unit = "K") "Average steam temperature between 434 K and 432.1 K" ;
Real Q3(unit = "kJ/hr") "Heat transfer" ;
Real t3(unit = "hr") "Time for heat transfer" ;
Real t(unit = "hr") "Total time" ;

//=======================================================
//Equation Section
equation
//I. At 6 bar g
v1 = V*x ;
v2 = V*(1-x) ;
w = v1*902.3+v2*3.674 ;
H1 = v1*902.3*697.38+v2*3.674*2762.1 ;
//II. At 436 K
x1/3.502+(w-x1)/904.31 = V ;
m1 = w-x1 ;
H2 = m1*688.53+x1*2759.9 ;
delta_H1 = H1-H2  ;
//III. At 434 K
x2/3.339+(w-x2)/906.28 = V ;
m2 = w-x2 ;
H3 = m2*679.82+x2*2757.8 ;
delta_H2 = H2-H3  ;
//IV. At 432.1 K
x3/3.176+(w-x3)/908.30 = V ;
m3 = w-x3 ;
H4 = m3*670.78+x3*2755.5 ;
delta_H3 = H3-H4 ;
//Temperature fall acalculations
//I. Average steam temperature between 438.2 K and 436 K
Ts1 = (438.2+436)/2 ;
Q1 = 0.045*(Ts1-Ta)*3600 ;
t1 = delta_H1/Q1 ;
//II. Average steam temperature between 436 K and 434 K
Ts2 = (436+434)/2 ;
Q2 = 0.045*(Ts2-Ta)*3600 ;
t2 = delta_H2/Q2 ;
//III. Average steam temperature between 434 K and 432.1 K
Ts3 = (434+432.1)/2 ;
Q3 = 0.045*(Ts3-Ta)*3600 ;
t3 = delta_H3/Q3 ;
t = t1+t2+t3 ;

//Note: Ref. Table 5.12, pg 243

end Ex5_18;
//=======================================================