//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.21 Page 248
//Title: Enthalpy calculations

//=======================================================
package Ex5_21

//=======================================================
model Ex5_21_a
/* Enthalpy of equimolar liq. mixture of n-pentane and n-hexane */

//=======================================================
//Parameter Section
parameter Real Tbb(unit = "K") = 321.6 "Bubble point of mixture" ;
parameter Real T0(unit = "K") = 298.15 "Reference temperature" ;

//=======================================================
//Variable Section
Real H1(unit = "kJ/kmol") "Enthalpy of n-pentane at Tbb" ;
Real H2(unit = "kJ/kmol") "Enthalpy of n-hexane at Tbb" ;
Real Hsol(unit = "kJ/kmol") "Enthalpy of equimolar mixture" ;
//=======================================================
//Equation Section
equation
H1 = 65.4961*(Tbb-T0)+628.628*10^(-3)*(Tbb^2-T0^2)/2-1898.8*10^(-6)*(Tbb^3-T0^3)/3+3186.51*10^(-9)*(Tbb^4-T0^4)/4 ;
H2 = 31.421*(Tbb-T0)+976.058*10^(-3)*(Tbb^2-T0^2)/2-2353.68*10^(-6)*(Tbb^3-T0^3)/3+3092.73*10^(-9)*(Tbb^4-T0^4)/4 ;
Hsol = 0.5*H1+0.5*H2 ;

//Note: Ref. Table 5.3

end Ex5_21_a ;
//=======================================================

//=======================================================
model Ex5_21_b
/* Enthalpy of equimolar vapour mixture */

//=======================================================
//Parameter Section
parameter Real Tdp(unit = "K") = 329.9 "Dew point of equimolar mixture" ;
parameter Real T0(unit = "K") = 298.15 "Reference temperature" ;
 
//=======================================================
//Variable Section
Real lambda_p(unit = "kJ/kmol") "Latent heat of vapourisation of n-pentane" ;
Real lambda_h(unit = "kJ/kmol") "Latent heat of vapourisation of n-hexane" ;
Real H1_ig(unit = "kJ/kmol") "Enthalpy of n-pentane vapour at Tdp" ;
Real H2_ig(unit = "kJ/kmol") "Enthalpy of n-hexane vapour at Tdp" ;
Real Hmix_ig(unit = "kJ/kmol") "Enthalpy of equimolar vapour mixture" ;

//=======================================================
//Equation Section
equation
lambda_p = 25790*((469.7-Tdp)/(469.7-309.2))^0.38 ;              //Watson equation
lambda_h = 28850*((507.6-Tdp)/(507.6-341.9))^0.38 ;              //Watson equation
H1_ig = 65.4961*(Tdp-T0)+628.628*10^(-3)*(Tdp^2-T0^2)/2-1898.8*10^(-6)*(Tdp^3-T0^3)/3+3186.51*10^(-9)*(Tdp^4-T0^4)/4+lambda_p ;
H2_ig = 31.421*(Tdp-T0)+976.058*10^(-3)*(Tdp^2-T0^2)/2-2353.68*10^(-6)*(Tdp^3-T0^3)/3+3092.73*10^(-9)*(Tdp^4-T0^4)/4+lambda_h ;
Hmix_ig = 0.5*H1_ig+0.5*H2_ig ;

end Ex5_21_b ;
//=======================================================


end Ex5_21;
