//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.23 Page 253
//Title: Cryogenic gas separation

//=======================================================
model Ex5_23

//=======================================================
//Parameter Section
parameter Real V(unit = "Nm^3/hr") = 12000 "Volumetric flow rate of feed" ;
parameter Real T1(unit = "K") = 147.65 "Temperature of incoming gas to I separater" ;
parameter Real T(unit = "K") = 118.15 "Temperature of incoming gas to II separater" ;

//=======================================================
//Variable Section
Real L(start = 0.1) "Liquid fraction produced in I separater" ;
Real n1(unit = "kmol/hr") "HP tail gas stream" ;
Real L1(start = 0.1) "Liquid fraction produced in II separater" ;
Real n2(unit = "kmol/hr") "LP tail gas stream" ;
Real n3(unit = "kmol/hr") "Product H2 stream" ;
Real P "Purity of H2 stream";

//=======================================================
//Equation Section
equation
0.6/(L+26.8*(1-L))+0.2/(L+0.4*(1-L))+0.2/(L+0.0045*(1-L)) = 1 ;
n1 = V/22.414*L ;
0.8617/(L1+42.9*(1-L1))+0.1355/(L1+0.09*(1-L1))+0.0028/(L1+2.38*10^(-4)*(1-L1)) = 1 ;
n2 = (V/22.414-n1)*L1 ;
n3 = V/22.414-n1-n2 ;
P = 315.35/n3*100 ;

end Ex5_23;
//=======================================================