//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.25 Page 257
//Title: Chlorination of benzene

//=======================================================
model Ex5_25

//=======================================================
//Parameter Section
parameter Real m(unit = "kmol/hr") = 100 "Benzene feed rate" ;
parameter Real x1 = 0.4 "kmol of Cl2 per kmol of C6H6" ;
parameter Real conv = 0.37  "Conversion of C6H6" ;
parameter Real yield = 0.9189 " Yield of MCB" ;

//=======================================================
//Variable Section
Real n1(unit = "kmol/hr") "Cl2 feed rate" ;
Real n2(unit = "kmol/hr") "C6H6 consumed" ;
Real n3(unit = "kmol/hr") "MCB production rate" ;
Real n4(unit = "kmol/hr") "1,4-DCB production rate" ;
Real F(unit = "kmol/hr") "Feed rate" ;
Real L(unit = "kmol/hr",start = 50) "Liquid product rate" ;
Real V(unit = "kmol/hr") "Vapour product rate" ;

//=======================================================
//Equation Section
equation
n1 = x1*m ;
n2 = conv*m ;
n3 = yield*n2 ;
n4 = n2-n3 ;
//Overall material balance
F = n1+n3+n4+(m-n2) ;
63/((1-0.3114)*L+F*0.3114)+34/((1-0.0508)*L+F*0.0508)+3/((1-0.0091)*L+F*0.0091) = 1 ;
V = F-L ;

//Note: 1 kmol of Cl2 produces 1 kmol of HCl
//Distribution coefficient of HCl at 328.15 K is very high thus x is negligible

end Ex5_25;
//=======================================================