//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.29 Page 261
//Title: Heat of formation of motor spirit

//=======================================================
model Ex5_29

//=======================================================
//Parameter Section
parameter Real m(unit = "kg") = 1 "Mass of motor spirit as basis" ;
parameter Real API = 64 "API gravity of motor spirit" ;

//=======================================================
//Variable Section
Real G "Specific gravity of motor spirit" ;
Real CH "C to H mass ratio of petroleum fraction" ;
Real C(unit = "kmol") "C content of motor spirit" ;
Real H(unit = "kmol") "H content of motor spirit" ;
Real O2(unit = "kmol") "O2 required for complete combustion of motor spirit" ;
Real Hf(unit = "kJ/kg") "Heat of formation" ;

//=======================================================
//Equation Section
equation
G = 141.5/(131.5+API) ;
CH = (74+15*G)/(26-15*G) ;
C = CH/(1+CH)*m/12 ;
H = (m-C*12)/2 ;
O2 = C+(H)/2 ;
//Assuming heat of combustion at 288.7 K = heat of reaction at 298.15
-44050 = -C*393.51*1000-H*241.82*1000-Hf ;

end Ex5_29;
//=======================================================