//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.33 Page 272
//Title: Heat of reaction of SO2

//=======================================================
model Ex5_33

//=======================================================
//Parameter XSection
parameter Real n(unit = "kmol") = 1 "Moles of SO2 reacted as basis" ;

//=======================================================
//Variable Section
Real delta_a "parameters of equation"  ;
Real delta_b "parameters of equation"  ;
Real delta_c "parameters of equation"  ;
Real delta_d "parameters of equation"  ;
Real Hr0(unit = "kJ/kmol") "Standard heat of reaction" ;
Real Hr1(unit = "kJ/kmol") "Standard heat of reaction at 298.15" ;
Real Hr2(unit = "kJ/kmol") "Standard heat of reaction at 775.15" ;
Real T1(unit = "K") = 298.15 "Temperature at which Hr to be found" ;
Real T2(unit = "K") = 778.15 "Temperature at which Hr to be found" ;

//=======================================================
//Equation Section
equation
delta_a = 22.036-24.771-0.5*(26.026) ;
delta_b = (121.624-62.948-0.5*11.755)*10^(-3) ;
delta_c = (-91.867-(-44.258)-0.5*(-2.343))*10^(-6) ;
delta_d = (24.369-11.122-0.5*(-0.562))*10^(-9) ;
Hr0 = -395720-(-296810) ;
Hr1 = Hr0-(delta_a*T1+delta_b*T1^2/2+delta_c*T1^3/3+delta_d*T1^4/4) ;
Hr2 = Hr1+delta_a*T2+26.4*10^(-3)*T2^2-15.48*10^(-6)*T2^3+3.382*10^(-9)*T2^4 ;

end Ex5_33;
//=======================================================