//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.38 Page 279
//Title: Loop reactor for EDC 

//=======================================================
package Ex5_38

//=======================================================
model Ex5_38_a
/* Composition of various stream */

//=======================================================
//Parameter Section
parameter Real F(unit = "kmol/hr") = 100 "Feed rate of ethylene" ;
parameter Real conv = 0.99 "Conversion of ethylene" ;
parameter Real yield = 0.998 "Yield of EDC" ;

//=======================================================
//Variable Section
Real n1(unit = "kmol/hr") "Ethylene consumed" ;
Real n2(unit = "kmol/hr") "Ethylene consumed as per rnx (i)" ;
Real n3(unit = "kmol/hr") "Ethylene consumed as per rnx (ii)" ;
Real n4(unit = "kmol/hr") "Cl2 consumed" ;
Real n5(unit = "kmol/hr") "Cl2 fed in reactor" ;
Real pv1(unit = "bar") "Vapour pressure of EDC" ;
Real pv2(unit = "bar") "Vapour pressure of TCE" ;
Real x_EDC "Mole fraction of EDC in liquid in reactor" ;
Real x_TEC "Mole fraction of TEC in liquid in reactor" ;
Real p_EDC(unit = "kPa") "Partial pressure of EDC" ;
Real p_TEC(unit = "kPa") "Partial pressure of TCE" ;
Real n_t(unit = "kmol/hr") "Total moles" ;
Real y_EDC "Mole fraction of EDC in vapour" ;
Real y_TEC "Mole fraction of EDC in vapour" ;
Real n_EDC(unit = "kmol/hr") "Moles of EDC" ;
Real n_TEC(unit = "kmol/hr") "Moles of TEC" ;

//=======================================================
//Equation Section
equation
n1 = conv*F ;
n2 = yield*n1 ;
n3 = n1-n2 ;
n4 = n2+2*n3 ;
n5 = F*1.1 ;
log10(pv1) = 4.58518-1521.789/(328.15-24.67) ;
log10(pv2) = 4.06974-1310.297/(328.15-64.41) ;
x_EDC = n2/(n2+n3) ;
x_TEC = 1-x_EDC ;
p_EDC = pv1*100*x_EDC ;
p_TEC = pv2*100*x_TEC ;
//(n_cl2+n_HCl+n_C2H4)/n_t = (p_cl2+p_HCl+p_C2H4)/p_t
((n5-n4)+n3+1)/n_t = 122.8107/160 ;
y_EDC = p_EDC/160 ;
y_TEC = p_TEC/160 ;
n_EDC = y_EDC*n_t ;
n_TEC = y_TEC*n_t ;

end Ex5_38_a ;
//=======================================================

//=======================================================
model Ex5_38_b
/* Heat duty of overhead condenser */

//=======================================================
//Parameter Section
parameter Real T0(unit = "K") = 273.15 "Reference temperature" ;
parameter Real T1(unit = "K") = 328.15 "Inlet temperature of gas into condenser" ;

//=======================================================
//Reference Section
extends Ex5_38_a; 

//=======================================================
//Variable Section
Real Q1(unit = "kJ/hr") "Enthalpy of gas stream entering overhead condenser" ;
Real Q2(unit = "kJ/hr") "Condensation heat duty" ;
Real Q3(unit = "kJ/hr") "Subcooling heat duty" ;
Real Qc(unit = "kJ/hr") "Total heat exchange in condenser" ;
Real m(unit = "kg/hr") "Mass flow rate of brine" ;

//=======================================================
//Equation Section
equation
Q1 = ((n5-n4)*33.9+n3*29.1+1*43.6+n_EDC*17.4+n_TEC*85.3)*(T1-T0) ;
Q2 = (35.053*1000*3.3947+39.58*1000*0.0025) ;
Q3 = (3.3947*129.4+0.0025*144.4)*(55/2) ;
Qc = Q1+Q2+Q3 ;
m = Qc/3.38/2 ;

//Note: Ref. Table 5.35

end Ex5_38_b ;
//=======================================================

//=======================================================
model Ex5_38_c
/* Heat duty of external condenser */

//=======================================================
//Parameter Section
parameter Real T0(unit = "K") = 273.15 "Reference temperature" ;
parameter Real T1(unit = "K") = 328.15 "Inlet temperature of gas into condenser" ;
parameter Real Hr0(unit = "kJ/mol") = -219.7 "Standard heat of rnx (i)" ;

//=======================================================
//Reference Section
extends Ex5_38_b ;

//=======================================================
//Variable Section
Real Q5(unit = "kJ/hr") "Enthalpy of feed" ;
Real Q6(unit = "kJ/hr") "Evaporation duty of organic vapours at 328.15 K" ;
Real Q7(unit = "kJ/hr") "Enthalpy of liquid product stream" ;
Real Hr1(unit = "kJ/mol") "Heat of reaction for rnx (i)" ;
Real Hr2(unit = "kJ/mol") "Heat of reaction for rnx (ii)" ;
Real Q8(unit = "kJ/hr") "Total heat generated" ;
Real Qcol(unit = "kJ/hr") "Heat duty of external cooler" ;
Real m1(unit = "kg/hr") "Mass flow rate of cooling water" ;

//=======================================================
//Equation Section
equation
Q5 = (F*43.6+n5*33.9)*(T1-T0) ;
Q6 = n_EDC*1000*33.6+n_TEC*1000*38.166 ;
Q7 = (98.5665*129.4+0.1988*144.4)*(T1-T0) ;
Hr1 = Hr0*1000+(129.4-43.6-33.9)*(T1-T0) ;
Hr2 = (-188+(-92.31)-52.5)*1000+(144.4+29.1-43.6+(-2)*33.9)*(T1-T0) ;
Q8 = -(Hr1*n2+Hr2*n3) ;
Qcol = Q5+Q8-Q1-Q6-Q7 ;
m1 = Qcol/(8*4.1868) ;

end Ex5_38_c ;
//=======================================================

end Ex5_38;
//=======================================================
