//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.39 Page 284
//Title: Conversions in adiabatic reactor 

//=======================================================
package Ex5_39

//=======================================================
model Ex5_39_a
/* Temperature of leaving gas using ideal gas mixture */

//=======================================================
//Parameter Section
parameter Real T0(unit = "K") = 298.15 "Reference temperature" ;
parameter Real T1(unit = "K") = 483.15 "Teperature of gas entering converter" ;

//=======================================================
//Variable Section
Real Q1(unit = "kJ/hr") "Enthalpy of ingoing gas" ;
Real Hr0(unit = "kJ/mol") "Standard heat of reaction" ;
Real n1(unit = "kmol/hr") "N2 reacted in converter" ;
Real Q2(unit = "kJ/hr") "Heat produced in converter" ;
Real Q3(unit = "kJ/hr") "Enthalpy of outgoing gas" ;
Real T2(unit = "K",start = 50) "Teperature of outcoming gas" ;

//=======================================================
//Equation Section
equation
Q1 = 12199.5*(T1-T0)+2241.4*10^(-3)*(T1^2-T0^2)/2+1557.7*10^(-6)*(T1^3-T0^3)/3-671.3*10^(-9)*(T1^4-T0^4)/4 ;
Hr0 = 2*(-45.94) ;
n1 = 92.674-69.506 ;
Q2 = -Hr0*1000*n1 ;
Q3 = Q1+Q2 ;
Q3 = 10713*(T2-T0)+3841*10^(-3)*(T2^2-T0^2)/2+1278.8*10^(-6)*(T2^3-T0^3)/3-752.5*10^(-9)*(T2^4-T0^4)/4 ;
end Ex5_39_a ;
//=======================================================

//=======================================================
model Ex5_39_b
/* Temperature of leaving gas using ideal gas behaviour */

//=======================================================
//Parameter Section
parameter Real T0(unit = "K") = 298.15 "Reference temperature" ;

//=======================================================
//Variable Section
Real Q(unit = "kJ/hr") "Enthalpy of outgoing gas" ;
Real T2(unit = "K",start = 50) "Teperature of outcoming gas" ;

//=======================================================
//Equation Section
equation
Q = 4715377 ;
Q = 10713.9*(T2-T0)+3841*10^(-3)*(T2^2-T0^2)/2+1278.8*10^(-6)*(T2^3-T0^3)/3-752.6*10^(-9)*(T2^4-T0^4)/4 ;
end Ex5_39_b ;
//=======================================================

end Ex5_39;
//=======================================================
