//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.4 Page 206
//Title: Heat added to toluene

//=======================================================
model Ex5_4

//=======================================================
//Parameter Section
parameter Real T1(unit = "K") = 290.15 "Initial temperature" ;
parameter Real T2(unit = "K") = 350.15 "Final temperature" ;
parameter Real m(unit = "kg/s") = 0.25 "Mass flow rate of toluene" ;

//=======================================================
//Variable Section
Real qm(unit = "kmol/s") "Molar flow rate of toluene" ;
Real H(unit = "kW") "Heat added" ;

//=======================================================
//Equation Section
equation 
qm = m/92 ;
//Reference 7
H = (1.8083*(T2-T1)+812.223*10^(-3)*(T2^2-T1^2)/2-1512.67*10^(-6)*(T2^3-T1^3)/3+1630.01*10^(-9)*(T2^4-T1^4)/4)*qm ;

//Note: Ref. 7 Table 5.3
end Ex5_4;