//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.40 Page 292
//Title: Burning of HCl 

//=======================================================
package Ex5_40

//=======================================================
model Ex5_40_a
/* Composition of dry gas leaving the burner */

//=======================================================
//Parameter Section
parameter Real n1(unit = "kmol") = 4 "Moles of HCl gads as basis" ; 
parameter Real n2(unit = "kmol") = 1 "Theoretical O2 requirement" ;
parameter Real conv = 0.80 "Conversion of HCl" ;

//=======================================================
//Variable Section
Real n3(unit = "kmol") "O2 supply" ;
Real n4(unit = "kmol") "N2 supply" ;
Real n5(unit = "kmol") "air supply" ;
Real n6(unit = "kmol") "HCl burnt" ;
Real n7(unit = "kmol") "HCl unburnt" ;
Real n8(unit = "kmol") "O2 unreacted" ;
Real n9(unit = "kmol") "Cl2 produced" ;
Real n10(unit = "kmol") "H2O produced" ;

//=======================================================
//Equation Section
equation
n3 = n2*1.35 ;                               //35% excess O2 supplied
n4 = (79/21)*n3 ;
n5 = n3+n4 ;
n6 = n1*conv ;
n7 = n1-n6 ;
n8 = n3-0.8 ;
n9 = 0.8*2 ;
n10 = 0.8*2 ;

end Ex5_40_a ;
//=======================================================

//=======================================================
model Ex5_40_b
/* Adiabatic temp. of product stream */

//=======================================================
//Parameter ection
parameter Real T0(unit = "K") = 298.15 "Base temperature" ;

//=======================================================
//Variable Section
Real Hr0(unit = "kJ/mol") "Std. heat of rnx at 298.15 K" ;
Real Q(unit = "kJ") "Total heat liberated" ;
Real T1(unit = "K",start = 50) "Adiabatic temp. of outlet gas" ;

//=======================================================
//Equation Section
equation
Hr0 = -241.82*2-4.0*(-92.31) ;
Q = -Hr0*1000*0.8 ;
//Hr1 =  0 + Q
Q = 286.544*(T1-T0)+12.596*10^(-3)*(T1^2-T0^2)/2+63.246*10^(-6)*(T1^3-T0^3)/3-25.933*10^(-9)*(T1^4-T0^4)/4 ;

//Note: Enthalpy of reactants at 298015 K is 0

end Ex5_40_b ;
//=======================================================

end Ex5_40;
//=======================================================
