//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.45 Page 297
//Title: Heat of solution of ZnSO4

//=======================================================
package Ex5_45

//=======================================================
model Ex5_45_a
/* Heat of solution of ZnSO4 using ZnSO4(s) */

//=======================================================
//Parameter Section
parameter Real Hf1(unit = "kJ/mol") = -982.8 "Heat of formation of ZnSO4(c)" ;
parameter Real Hf2(unit = "kJ/mol") = -1053.904 "Heat of formation of ZnSO4.15H2O" ;

//=======================================================
//Variable Section
Real Hdis(unit = "kJ/mol") "Heat of dissolution" ;

//=======================================================
//Equation Section
equation
Hdis = Hf2-Hf1 ;

end Ex5_45_a ;
//=======================================================

//=======================================================
model Ex5_45_b
/* Heat of solution of ZnSO4 using ZnSO4.7H2O */

//=======================================================
//Parameter Section
parameter Real Hf1(unit = "kJ/mol") = -285.83 "Heat of formation of H2O" ;
parameter Real Hf2(unit = "kJ/mol") = -1053.904 "Heat of formation of ZnSO4.15H2O" ;
parameter Real Hf3(unit = "kJ/mol") = -3077.75 "Heat of formation of ZnSO4.7H2O" ;

//=======================================================
//Variable Section
Real Hdis(unit = "kJ/mol") "Heat of dissolution" ;

//=======================================================
//Equation Section
equation
Hdis = Hf2+7*Hf1-Hf3 ;

end Ex5_45_b ;
//=======================================================


end Ex5_45;
//=======================================================
