//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.54 Page 311
//Title: Resultant temperature calculation

//=======================================================
package Ex5_54

//=======================================================
model Ex5_54_a
/* From Fig. 5.22 */

//=======================================================
//Variable Section
Real H(unit = "kJ/kg") "Enthalpy of NH3 gas at 101.3 kPa a and 323.15 K";  
Real T0(unit = "K") "Reference temperature" ;
Real h(unit = "kJ/kg") "Enthalpy of NH3" ;
Real T(unit = "K") "Temperature of resultant solution" ;

//=======================================================
//Equation Section
equation
//From Ref. 24
H = 1600.83 ;
T0 = 273.15 ;
h = 200 ;
T = 373.15 ;

end Ex5_54_a ;
//=======================================================

//=======================================================
model Ex5_54_b
/* From data given from Table 5.59 */

//=======================================================
//Parameter Section
parameter Real m(unit = "kg/hr") = 140 "Ammonia vapours produced" ;
parameter Real Cp(unit = "kJ/(kg K)") = 4.145 "Heat capacity of NH3 solution" ;
parameter Real T1(unit = "K") = 303 "Inlet water temperature" ;

//=======================================================
//Variable Section
Real Hf1(unit = "kJ/mol") "Heat of formation of 15% NH3" ;
Real Hf2(unit = "kJ/mol") "Heat of formation of gaseous NH3";
Real Hsol(unit = "kJ/mol") "Heat of solution" ;
Real Q(unit = "kJ/hr") "Total heat generated ";
Real m1(unit = "kg/hr") "Aqueous solution rate" ;
Real delta_T(unit = "K") "Rise in temoerature" ;
Real T(unit = "K") "Temperature of aqueous solution" ;

//=======================================================
//Equation Section
equation
Hf1 = -79.3 ;
Hf2 = -46.11 ;
Hsol = Hf1-Hf2 ;
Q = -Hsol*1000*m/17.0305 ;
m1 = m/0.15 ;
delta_T = Q/(Cp*m1) ;
T = T1+delta_T ;

end Ex5_54_b ;
//=======================================================

end Ex5_54;
//=======================================================
