//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.57 Page 314
//Title: Partial Molar enthalpy

//======================================================
package Ex5_57

//======================================================
model Ex5_57_a
/* H  calculation */

//======================================================
//Parameter Section
parameter Real T0(unit = "K") = 273.15 "Reference temperature" ;
parameter Real C1(unit = "kJ/kmol K") = 124.8 "Av.Molar heat capacity of acetone" ;
parameter Real C2(unit = "kJ/kmol K") = 134.9 "Av.Molar heat capacity of Ethyl acetate" ;
parameter Real T1(unit = "K") = 308.15 "Temperature" ;
parameter Real x[11] = {0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1} ;

//======================================================
//Variable Section
Real H1(unit = "kJ/kmol") "Enthalpy of acetone at 308.15 K" ;
Real H2(unit = "kJ/kmol") "Enthalpy of ethyl acetate at 308.15 K" ;
Real Hid[11] "H of ideal solution" ;
Real H[11] "H of solution" ;

//======================================================
//Equation Section
equation
H1 = C1*(T1-T0) ;
H2 = C2*(T1-T0) ;
for i in 1:11 loop 
 Hid[i] = x[i]*H1+(1-x[i])*H2 ;
 H[i] =  x[i]*(1-x[i])*(542.4+55.4*(1-2*x[i])-132.8*(1-2*x[i])^2-168.9*(1-2*x[i])^3)+H1*x[i]+H2*(1-x[i]) ;
end for ;

end Ex5_57_a ;
//======================================================

//======================================================
model Ex5_57_b
/* Expression for partial molar enthalpies*/

//H1 = 4664.1+2275.4*x1-13118.5*x1^2-23624*x1^3-18483.6*x1^4+5404.8*x1^5
//H2 = 4721.5-1137.7*x1^2+7987.2*x1^3-11727.6*x1^4+5404.8*x1^5

end Ex5_57_b ;
//======================================================

//======================================================
model Ex5_57_c
/* H1 and H2 */

//======================================================
//Variable Section
Real H1E1(unit = "kJ/kmol") "Partial molar enthalpy of acetone at 0.3" ;
Real H1E2(unit = "kJ/kmol") "Partial molar enthalpy of Ethyl acetate at 0.3" ;
Real H2E1(unit = "kJ/kmol") "Partial molar enthalpy of acetone at 0.6" ;
Real H2E2(unit = "kJ/kmol") "Partial molar enthalpy of Ethylacetate at 0.6" ;

//======================================================
//Equation Section
equation
//From Fig. 5.23
H1E1 = 4667 ;
H1E2 = 4753 ;
H2E1 = 4434 ;
H2E2 = 4938 ;

end Ex5_57_c ;
//======================================================

end Ex5_57;
//======================================================
