//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-5: Energy Balances
//Example: 5.8 Page 210
//Title: Subcooling in condenser 

//=======================================================
model Ex5_8

//=======================================================
//Parameter Section
parameter Real T1(unit = "K") = 373.15 "Initial temperature" ;
parameter Real T2(unit = "K") = 313.15 "Final temperature" ;
parameter Real m(unit = "kg/hr") = 8000 "Mass flow rate of cooling water" ;
parameter Real x = 0.118 "Fraction of Aniline in mixture" ;

//=======================================================
//Variable Section
Real qn1(unit = "kmol/hr") "Aniline in mixture" ;
Real qn2(unit = "kmol/hr") "Water in  mixture" ;
Real Q(unit = "kW") "Heat removed" ;

//=======================================================
//Equation Section
equation
qn1 = m*x/94 ;
qn2 = (m-qn1*94)/18 ;
Q = ((qn1*206.27+qn2*50.845)*(T1-T2)+(qn1*(-211.5065*10^(-3))+qn2*213.08*10^(-3))*(T1^2-T2^2)/2+(qn1*564.2902*10^(-6)+qn2*(-631.398)*10^(-6))*(T1^3-T2^3)/3+(qn2*648.746*10^(-9)*(T1^4-T2^4)/4))/3600 ;

end Ex5_8;
//=======================================================