//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.13 Page 383
//Title: Dew point calculation

//======================================================
model Ex6_13

//======================================================
//Parameter Section
parameter Real Pw1(unit = "Pa") = 12.84 "Vapour pressure of ice at 233.15 K" ;
parameter Real P1(unit = "Pa") = 101325 "Total pressure" ;
parameter Real p2(unit = "Pa") = 801326 "Pressure of air" ;       //Pabs = Pgauge+1013225=700000+101325

//======================================================
//Variable Section
Real Hm "Humidity in kmol of H2O/kmol of dry air" ;
Real T(unit = "K") "Dew point Temperature" ;

//======================================================
//Equation Section
equation
Hm = Pw1/(P1-Pw1) ;
//From Table 6.12,dew point 
T = 252.97 ;

end Ex6_13;
//======================================================
