//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.14 Page 384
//Title: Psychrometric calculations for ambient air

//======================================================
package Ex6_14

//======================================================
model Ex6_14_a 
/*  Absolute molar humidity */

//======================================================
//Parameter Section
parameter Real Pw(unit = "kPa") = 2.0624 "Partial pressure of water in air" ;
parameter Real P(unit = "kPa") = 100 "Total pressure" ;

//======================================================
//Variable Section
Real Hm "Absolute molar humidity in kmol H2O(g)/Kmol dry air" ;

//======================================================
//Equation Section
equation
//At DP partial pressure of water = Vapor pressure
Hm = Pw/(P-Pw) ;

end Ex6_14_a ;
//======================================================

//======================================================
model Ex6_14_b
/* Absolute humidity */

//======================================================
//Reference Section
extends Ex6_14_a ;

//======================================================
//Variable Section
Real H "Absolute humidity in kg H2o(g)/kg dry air" ;

//======================================================
//Equation Section
equation
H = Hm*0.622 ;                                 // 18/29 = 0.622

end Ex6_14_b ;
//======================================================

//======================================================
model Ex6_14_c
/* % RH */

//======================================================
//Parameter Section
parameter Real Pw(unit = "kPa") = 2.0624 "Partial pressure of water in air" ;
parameter Real P(unit = "kPa") = 100 "Total pressure" ;
parameter Real Ps(unit = "kPa") = 4.004 "Vapor pressure at saturation at 302.15 K" ;

//======================================================
//Variable Section
Real RH "Relative humidity" ;

//======================================================
//Equation Section
equation
//At saturation DB = WB = DP
RH = Pw/Ps*100 ;

end Ex6_14_c ;
//======================================================

//======================================================
model Ex6_14_d
/* % saturation */

//======================================================
//Parameter Section
parameter Real Ps(unit = "kPa") = 4.004 "Vapor pressure at saturation at 302.15 K" ;
parameter Real P(unit = "kPa") = 100 "Total pressure" ;

//======================================================
//Reference Section
extends Ex6_14_b ;

//======================================================
//Variable Section
Real Hs "Absolute humidity at saturation" ;
Real Sat "% Saturation" ;

//======================================================
//Equation Section
equation
Hs = 0.622*Ps/(P-Ps) ;
Sat = H/Hs*100 ;

end Ex6_14_d ;
//======================================================

//======================================================
model Ex6_14_e
/* Humid heat */

//======================================================
//Parameter Section
//From Fig. 6.15
parameter Real ias(unit = "kJ/kg") = 62.3 "Enthalpy per kg dry air at saturation at WB = 294.55 K" ;
parameter Real d(unit = "kJ/kg") = -0.28 "Enthalpy per kg dry air deviation" ;

//======================================================
//Reference Section
extends Ex6_14_b ;

//======================================================
//Variable Section
Real i1(unit = "kJ/kg") "Enthalpy of air-water per kg dry air system at 101.325 kPa" ;
Real i(unit = "kJ/kg") "Enthalpy of air-water per per dry air system at 100 kPa" ;
Real CH(unit = "kJ/kg") "Humid heat per kg dry air" ;

//======================================================
//Equation Section
equation
i1 = ias+d ;                         //At 101.325 kPa
i = 62.52 ;                          //At 100 kPa
CH = 1.006+1.84*H ;

end Ex6_14_e ;
//======================================================

//======================================================
model Ex6_14_f
/* Humid volume */

//======================================================
//Parameter Section
parameter Real Tdb(unit = "K") = 302 "Dry bulb temperature" ;
parameter Real Mw(unit = "kg/kmol") = 18 "Molar mass of water" ;
parameter Real Ma(unit = "kg/kmol") = 29 "Molar mass of water" ;

//======================================================
//Reference Section
extends Ex6_14_b;

//======================================================
//Variable Section
Real VH(unit = "m^3/kg") "Humid volume of dry air" ;

//======================================================
//Equation Section
equation
VH = ((H/Mw)+(1/Ma))*22.414*(Tdb/273.15)*(101.325/P) ;

end Ex6_14_f ;
//======================================================

end Ex6_14;
//======================================================
