//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.15 Page 385
//Title: Humidification of air in textile industry

//======================================================
package Ex6_15

//======================================================
model Ex6_15_a
/* Moisture added */

//======================================================
//Parameter Section
parameter Real m(unit = "kg") = 1 "Mass of dry air entering air washer" ;
parameter Real RH1  = 95 "Relative humidity of air leaving washer" ;

//======================================================
//Variable Section
Real H1 "Absolute humidity of air in g H2O(g)/kg dry air before saturation" ;
Real H2 "Absolute humidity of air in g H2O(g)/kg dry air after saturation" ;
Real H "Moisture added" ;

//======================================================
//Equation Section
equation
H1 = 11.8 ;
H2 = 17.76 ;                                     // At 95% RH
H = H2-H1 ;

end Ex6_15_a ;
//======================================================

//======================================================
model Ex6_15_b
/* Wet bulb and dry bulb temperatures */

//======================================================
//Variable Section
Real DB(unit = "K") "Dry bulb temperature" ;
Real WB(unit = "K") "Wet bulb temperature" ;
Real DP(unit = "K") "Dew point temperature" ;

//======================================================
//Equation Section
equation
DB = 300.95 ;                              //At 80% RH
WB = 298.15 ;                              //At 80% RH
DP = 297.15 ;                              //At 80% RH
//Refer psychrometric chart, Ref. Fig. 6.15

end Ex6_15_b ;
//======================================================

//======================================================
model Ex6_15_c
/* Heat load */

//======================================================
//Reference Section
extends Ex6_15_a ;
extends Ex6_15_b ;

//======================================================
//Variable Section
Real CH(unit = "kJ/kg") "Humid heat" ;
Real Q1(unit = "kJ/kg") "Heat supplied per kg dry air" ;

//======================================================
//Equation Section
equation
CH = 1.006+1.84*(H2/1000) ;
Q1 = CH*(DB-DP) ;

end Ex6_15_c ;
//======================================================

//======================================================
model Ex6_15_d
/* Steam consumption */

//======================================================
//Parameter Section
parameter Real q(unit = "m^3/hr") = 25000 "Actual air flow rate" ;
parameter Real lambda(unit = "kJ/kg") = 2163.2 "Latent heat at 300 kPa" ;

//======================================================
//Reference Section
extends Ex6_15_c ;

//======================================================
//Variable Section
Real VH(unit = "m^3/kg") "Humid volume per kg dry air" ;
Real qm(unit = "kg/hr") "Mass flow rate of air" ;
Real Q(unit = "kW") "Heat load on heater" ;
Real ms(unit = "kg/hr") "Steam consumption" ;

//======================================================
//Equation Section
equation
VH = 0.9067 ;                               //From Fig. 6.15
qm = q/VH ;
Q = qm*Q1/3600 ;
ms = Q*3600/lambda ;

end Ex6_15_d ;
//======================================================

end Ex6_15;
//======================================================
