//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.17 Page 389
//Title: Waste heat recovery unit

//======================================================
package Ex6_17

//======================================================
model Ex6_17_a
/* Heat loss rate */

//======================================================
//Parameter Section
parameter Real m(unit = "kg") = 1 "Basis for dry air fed" ;
//Ref. Fig. 6.16
parameter Real DB(unit = "K") = 393.15 "Dry bulb temperature" ;
parameter Real WB(unit = "K") = 330.15 "Dry bulb temperature" ;
parameter Real DP1(unit = "K") = 325.15 "Dew point temperature" ;
parameter Real H1 = 0.0972 "Abs. Humidity of entering air in kg H2O/kg dry air" ;
parameter Real H2 = 0.0492 "Abs. Humidity of saturated air in kg H2O/kg dry air" ;
parameter Real DP2(unit = "K") = 313.15 "Dew point of outlet gas" ;
parameter Real ma(unit = "kg/hr") = 2000 "Mass flow rate of hot air" ;

//======================================================
//Variable Section
Real H "Moisture condensed" ;
Real CH1(unit = "kJ/kg") "Humid heat of entering air" ;
Real CH2(unit = "kJ/kg") "Humid heat of saturated air" ;
Real ia1(unit = "kJ/kg") "Enthalpy of entering air" ;
Real ia2(unit = "kJ/kg") "Enthalpy of outgoing air" ;
Real i(unit = "kJ/kg") "Total heat removed" ;
Real qm(unit = "kg/hr") "Mass flow rate of dry air" ;
Real Q1(unit = "kW") "Heat lost from air" ;

//======================================================
//Equation Section
equation 
H = H1-H2 ;
CH1 = 1.006+1.84*H1 ;
CH2 = 1.006+1.84*H2 ;
ia1 = 1.006*(DP1-273.15)+H1*2596+CH1*(DB-DP1) ;
ia2 = 1.006*(DP2-273.15)+H2*2574.4 ;
i = ia1-ia2 ;
qm = ma/(1+H1) ;
Q1 = i*qm/3600 ;
 
end Ex6_17_a ;
//======================================================

//======================================================
model Ex6_17_b
/* % heat recovery in hot water */

//======================================================
//Parameter Section
parameter Real mw(unit = "L/s") = 1.167 "Mass flow rate of cooling water" ;
parameter Real T1(unit = "K") = 305.15 "Inlet temperature of cooling water" ;
parameter Real T2(unit = "K") = 323.15 "Outlet temperature of cooling water" ;

//======================================================
//Refernce Section
extends Ex6_17_a ;

//======================================================
//Variable Section
Real Q2(unit = "kW") "Heat gained by water" ;
Real rec "Heat recovery" ;

//======================================================
//Equation Section
equation 
Q2 = mw*4.1868*(T2-T1) ;
rec = Q2*100/Q1 ;

end Ex6_17_b ;
//======================================================

end Ex6_17;
//======================================================
