//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.18 Page 390
//Title: Recovery of CS2 by adsorption

//======================================================
package Ex6_18

//======================================================
model Ex6_18_a
/* Volumetric flow rate of feed */

//======================================================
//Parameter Section
parameter Real F(unit = "kmol") = 800 "Inlet CS2-H2 mixture" ;
parameter Real Pcs2_in(unit = "kPa") = 16.93 "Partial pressure of inlet feed CS2" ;
parameter Real P(unit = "kPa") = 106.7 "Total pressure" ;
parameter Real Pcs2_out(unit = "kPa") = 6.19 "Vapour pressure at DP of CS2 in outlet" ;
parameter Real Md(unit = "kg/hr") = 600 "Design adsorption rate of CS2" ;

//======================================================
//Variable Section
Real n1(unit = "kmol") "CS2 in feed" ;
Real n2(unit = "kmol") "H2 in feed" ;
Real n3(unit = "kmol") "CS2 leaving adsorber" ;
Real n4(unit = "kmol") "CS2 adsorbed" ;
Real m(unit = "kg") "Mass of CS2 adsorbed" ;
Real nf(unit = "kmol/hr") "Molar flow rate of inlet gas mixture" ;
Real sp_vol(unit = "m^3/kmol") "Specific volume of ideal gas at 106.7 kPa and 293.15 K" ;
Real q(unit = "m^3/hr") "Volumetric flow rate of incoming gas" ;

//======================================================
//Equation Section
equation
n1 = Pcs2_in/P*F ;
n2 = F-n1 ;
n3 = Pcs2_out/(101.325-Pcs2_out)*n2 ;
n4 = n1-n3 ;
m = n4*76.1407 ;
nf = F/m*Md ;
sp_vol = 8.314472*293.15/P ;
q = sp_vol*nf ;

end Ex6_18_a ;
//======================================================

//======================================================
model Ex6_18_b
/* Activated C requirement */

//======================================================
//Parameter Section
parameter Real ms1(unit = "kg") = 0.04 "CS2 in regenerated catalyst per kg of BD activated carbon" ;
parameter Real ms2(unit = "kg") = 0.32 "CS2 in leaving catalyst per kg of BD activated carbon" ;
parameter Real Md(unit = "kg/hr") = 600 "Design adsorption rate of CS2" ;
//======================================================
//Variable Section
Real ms(unit = "kg") "CS2 adsorbed catalyst per kg of BD activated carbon" ;
Real qm(unit = "kg/hr") "Mass flow rate of activated carbon" ;

//======================================================
//Equation Section
equation
ms = ms2-ms1 ;
qm = Md/ms*1.04 ;

end Ex6_18_b ;
//======================================================

//======================================================
model Ex6_18_c
/* Temperature */

//======================================================
//Parameter Section
parameter Real P(unit = "kPa") = 405 "Pressure of CS2-H1 mixture after compression" ;

//======================================================
//Variable Section
Real c "Final desired concentration of outlet CS2-H2" ;
Real Pcs2(unit = "kPa") "Vapour pressure of CS2 after cooling after compression" ;
Real T(unit = "K") "Saturation temperature" ;

//======================================================
//Equation Section
equation
c = 43.8/673.1 ;
c = Pcs2/(P-Pcs2) ;
//T corresponding to Pcs2
T = 281.7 ;

end Ex6_18_c ;
//======================================================

end Ex6_18;
//======================================================
