//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.21 Page 396
//Title: Rotary drier

//======================================================
package Ex6_21

//======================================================
model Ex6_21_a 
/* Flow rate of incoming air */

//======================================================
//Parameter Section
parameter Real x1 = 0.25 "Moisture content in mole fraction of wet feed";
parameter Real x2 = 0.02 "Moisture content in mole fraction of dried solid";
parameter Real m(unit = "kg/hr") = 1000 "Product flow rate" ;
parameter Real H1 = 0.036 "Abs. humidity of incoming air" ;
parameter Real T0(unit = "K") = 273.15 "Reference Temperature" ;

//======================================================
//Variable Section
Real X1 "Moisture regain of incoming solid" ;
Real X2 "Moisture regain of outgoing solid" ;
Real ms(unit = "kg/s") "Mass flow rate of solids" ;
Real ma(unit = "kg/s") "Mass flow rate of air" ;
Real H2 "Abs. humidity of outing air" ;
Real is1(unit = "kJ/kg") "Enthalpy of solid at inlet" ;
Real is2(unit = "kJ/kg") "Enthalpy of solid at outlet" ;
Real ia1(unit = "kJ/kg") "Enthalpy of air at inlet" ;
Real ia2(unit = "kJ/kg") "Enthalpy of air at outlet" ;


//======================================================
//Equation Section
equation
X1 = x1/(1-x1) ;
X2 = x2/(1-x2) ;
ms = m/3600*(1-x2) ;
ms*(X1-X2) = ma*(H2-H1) ;
is1 = 1.43*(303.15-T0)+X1*4.1868*(303.15-T0) ;
is2 = 1.43*(353.15-T0)+X2*4.1868*(353.15-T0) ;
ia1 = 1.006*(308.15-T0)+H1*2565.4+1.072*(393.15-308.15) ;
ma*(0.056-0.036) = 0.085 ;
//Assume tDP2 = 315.55 K
ia2 = 1.006*(315.55-T0)+0.056*2578.6+(1.006+1.84*0.056)*(323.15-315.55) ;

end Ex6_21_a ;
//======================================================

//======================================================
model Ex6_21_b 
/* Humidity of air */

//======================================================
//Variable Section
Real H "Humidity of outgoing air" ;

//======================================================
//Equation Section
equation
//For tDP2 = 315.55 K
//From Fig. 6.15
H = 0.056 ;

end Ex6_21_b ;
//======================================================

//======================================================
model Ex6_21_c 
/* Steam consumption */

//======================================================
//Parameter Section
parameter Real T0(unit = "K") = 273.15 "Reference Temperature" ;
parameter Real T1(unit = "K") = 308.15 "Temperature of fully saturated air" ;

//======================================================
//Variable Section
Real iaa(unit = "kJ/kg") "Enthalpy of outgoing air" ;
Real Q(unit = "kW") "Heat removed" ;
Real ms(unit = "kg/hr") "Steam consumption" ;

//======================================================
//Equation Section
equation
iaa = 1.006*(T1-T0)+0.036*2565.4 ;
Q = 4.25*(218.68-iaa) ;
ms = Q/2133*3600 ;                                   //Lambda = 2133 kJ/kg at 4 bar a Ref. Appx IV.1

end Ex6_21_c ;
//======================================================

end Ex6_21;
//======================================================
