//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.22 Page 398
//Title: Hot air dryer in textile mill

//======================================================
package Ex6_22
  
//======================================================
model Ex6_22_i
/* Mass of bone dry solids */
//======================================================
//Parameter Section
parameter Real v(unit = "m/s") = 1.15 "Cloth speed";
parameter Real x1 = 0.9 "Inlet moisture content of cloth";
parameter Real x2 = 0.06 "outlet moisture content of cloth";
parameter Real w(unit = "m") = 1.20 "Width of cloth";
parameter Real rho(unit = "kg/m^2") = 0.095 "Specific density of BD cloth";

//======================================================
//Variable Section
Real BD(unit = "kg/hr") "Producton of bone dry cloth";
Real evap(unit = "kg/hr") "Raete of eavporation";
Real H1 "Inlet humidity of air";
Real H2 "Outlet humidity of air";
Real H "Raise in humidity of air";
Real qm1(unit = "kg/hr") "Fresh air rate";
Real qv(unit = "kg/hr") "Volumetric flow rate of incoming air";
Real VH(unit = "m^3/kg") "Humid volume of air at 303.15 DB and 298.15 K WB";

//======================================================
//Equation Section
equation
BD = v * w * rho * 3600;
evap = BD * (x1 - x2);
//From Fig. 6.15 and 6.16
H1 = 0.01805;
H2 = 0.0832;
H = H2 - H1;
qm1 = evap / H;
VH = 0.8837;
qv = qm1 * VH;
end Ex6_22_i;

//======================================================

//======================================================
model Ex6_22_ii
/* Heat balance of dryer */

//======================================================
//Parameter Section
parameter Real T0(unit = "K") = 273.15 "Reference temperature";
parameter Real T1(unit = "K") = 303.15 "Inlet temperature of ambient air";
parameter Real T2(unit = "K") = 368.15 "Outlet temperature of air";
parameter Real ms(unit = "kg/hr") = 885 "steam consumption";

//======================================================
//Reference Section
extends Ex6_22_i;

//======================================================
//Variable Section
Real Q1(unit = "kW") "Heat picked up by cloth";
Real Q2(unit = "kW") "Heat of evaporation occuring at DP";
Real ia1(unit = "kJ/kg") "Enthalpy of ambient air";
Real ia2(unit = "kJ/kg") "Enthalpy of outgoing air";
Real Q3(unit = "kW") "Heat input by steam";
Real Q4(unit = "kW") "Heat lost in condensate";
Real qm2 "Specific steam consumption";

//======================================================
//Equation Section
equation
Q1 = (BD * 1.256 * (T2 - T1) + BD * x2 * (T2 - T1) * 4.1868) / 3600;
Q2 = (evap * (322.5 - T1) + evap * 2384.1) / 3600;
ia1 = 1.006 * (T1 - T0) + 2556.4 * H1;
ia2 = 1.006 * (322.8 - T0) + 2591.5 * H2 + (1.006 + 1.84 * H2) * (393 - 328.8);
Q3 = (720.94 + 2046.5) * ms / 3600;
Q4 = 720.94 * ms / 3600;
qm2 = ms / evap;

end Ex6_22_ii;
//======================================================

end Ex6_22;
//======================================================