//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.25 Page 405
//Title: Four compartment washing thickner

//======================================================
model Ex6_25

//======================================================
//Parameter Section
parameter Real M2(unit = "kg") = 1 "Basis for stream M2" ;
parameter Real M2_CaCO3(unit = "kg") = 0.349 "Mass of CaCO3 in stream M2" ;
parameter Real M2_l(unit = "kg") = 0.651 "Mass of liquor in stream M2" ;
parameter Real rho(unit = "kg/L") = 2.711 "Density of CaCO3" ;

//======================================================
//Variable Section
Real V1(unit = "L") "Volume of CaCO3 in M2" ;
Real V2(unit = "L") "Volume of liquor in M2" ;
Real V_M2(unit = "L") "Total volume of  M2" ;
Real sp_gr1 "Specific gravity of M2 slurry" ;
Real m1(unit = "kg/hr") "Slurry flow" ;
Real m2(unit = "kg/hr") "Suspended solids in M2" ;
Real m3(unit = "kg/hr") "Liquor present in M2" ;
Real m4(unit = "kg/hr") "Na2O in M2" ;
Real m1_O2(unit = "kg/hr") "Slurry flow in stream O2" ;
Real m2_O2(unit = "kg/hr") "Suspended solids in O2" ;
Real m3_O2(unit = "kg/hr") "Liquor present in O2" ;
Real m4_O2(unit = "kg/hr") "Na2O in O2" ;
Real M1(unit = "L") "Total volume of M1 stream" ;
Real sp_gr2 "Specific gravity of M1 slurry" ;
Real m1_M1(unit = "kg/hr") "Slurry flow in stream M1" ;
Real m3_M1(unit = "kg/hr") "Liquor present in M1" ;
Real m4_M1(unit = "kg/hr") "Na2O in M1" ;
Real m1_O1(unit = "kg/hr") "Slurry flow in stream O1" ;
Real m2_O1(unit = "kg/hr") "Suspended solids in O1" ;
Real m3_O1(unit = "kg/hr") "Liquor present in O1" ;
Real m4_O1(unit = "kg/hr") "Na2O in O1" ;
Real W(unit = "L") "Total volume of W stream" ;
Real sp_gr3 "Specific gravity of W slurry" ;
Real m1_W(unit = "kg/hr") "Slurry flow in stream W" ;
Real m2_W(unit = "kg/hr") "Suspended solids in W" ;
Real m3_W(unit = "kg/hr") "Liquor present in W" ;
Real m4_W(unit = "kg/hr") "Na2O in W" ;
Real M0(unit = "L") "Total volume of M0 stream" ;
Real sp_gr4 "Specific gravity of M0 slurry" ;
Real m1_M0(unit = "kg/hr") "Slurry flow in stream M0" ;
Real m2_M0(unit = "kg/hr") "Suspended solids in M0" ;
Real m3_M0(unit = "kg/hr") "Liquor present in M0" ;
Real m4_M0(unit = "kg/hr") "Na2O in M0" ;

//======================================================
//Equation Section
equation
//Stream M2
V1 = M2_CaCO3/rho ;
V2 = M2_l/1.167 ;
V_M2 = V1+V2 ;
sp_gr1 = 1/V_M2 ;
m1 = 2.845*3600*sp_gr1 ;
m2 = m1*M2_CaCO3 ;
m3 = m1*M2_l ;
m4 = m3*0.1342/1.167 ;
//Stream O2
m1_O2 = 14.193*3600*1.037 ;          //Specific gravity of slurry = Specific gravity of liquor
m2_O2 = m1_O2*0.03/100 ;
m3_O2 = m1_O2-m2_O2 ;
m4_O2 = m3_O2*0.0272/1.037 ;
//Stream M1
M1 = (0.194/rho)+(0.806/1.037) ;
sp_gr2 = 1/M1 ;
//Assume all suspended solids in M2 are recovered in M1
m1_M1 = m2/0.194 ;
m3_M1 = m1_M1-m2 ;
m4_M1 = m3_M1*0.0252/1.034 ;
//Stream O1
m1_O1 = m1_O2+m1_M1-m1 ;          
m2_O1 = m1_O1*0.02/100 ;
m3_O1 = m1_O1-m2_O1 ;
m4_O1 = m3_O1*0.0096/1.014 ;
//Stream W
W = (0.037/rho)+(0.963/1) ;
sp_gr3 = 1/W ;
m1_W = 14.977*3600*sp_gr3 ;          
m2_W = m1_W*0.037 ;
m3_W = m1_W-m2_W ;
m4_W = m3_W*0.0024/1 ;
//Stream M0
M0 = (0.402/rho)+(0.598/1.022) ;
sp_gr4 = 1/M0 ;
m1_M0 = 3.627*3600*sp_gr4 ;
m2_M0 = m1_M0*0.402 ;
m3_M0 = m1_M0-m2_M0 ;
m4_M0 = m3_M0*0.0162/1.022 ;

end Ex6_25;
//======================================================
