//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.4 Page 355
//Title: Absorption of CO2 in MEA

//======================================================
model Ex6_4

//======================================================
//Parameter Section
parameter Real m(unit = "L/s") = 0.625 "Flow rate of MEA solution" ;
parameter Real C(unit = "mol/L") = 3.2 "Molarity of MEA soln." ;
parameter Real x1 = 0.166 "Dissolved CO2 in lean MEA in kmol of CO2/kmol of MEA"; 
parameter Real Q(unit = "m^3/hr") = 1000 "Volumetric flow rate of dry air" ;

//======================================================
//Variable Section
Real c(unit = "g/L") "Concentration of MEA in soln." ;
Real m1(unit = "kg/hr") "Total MEA entering tower" ;
Real n1(unit = "kmol/hr") "Total moles MEA entering tower" ;
Real n2(unit = "kmol/hr") "CO2 in lean MEA" ;
Real n3(unit = "kmol/hr") "Molar flow rate of inlet air" ;
Real n4(unit = "kmol/hr") "CO2 in inlet gas" ;
Real out(unit = "kmol/hr") "Molar flow rate of outgoing gas" ;
Real n5(unit = "kmol/hr") "CO2 absorbed" ;
Real n6(unit = "kmol/hr") "CO2 free gas" ;
Real n7(unit = "kmol/hr") "CO2 in MEA rich solution" ;
Real conc "Concentration of CO2 in MEA soln. " ;

//======================================================
//Equation Section
equation
c = C*61 ;
m1 = c*m*3600/1000 ;
n1 = m1/61 ;
n2 = x1*n1 ;
n3 = Q/26.107 ;                    //Molar volume of air is 26.107 m3/kmol Ref. Table 7.8
n4 = n3*0.104 ;
n6 = n3-n4 ;
out = n6/(1-0.0455) ;
n5 = n3-out ;
n7 = n2+n5 ;
conc = n7/n1 ;

end Ex6_4;
//======================================================