//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-6: Stoichiometry and Unit Operations
//Example: 6.9 Page 367
//Title: Yield of glauber salt

//======================================================
model Ex6_9

//======================================================
//Parameter Section
parameter Real F(unit = "kg") = 100 "Mass of free water as basis" ;
parameter Real m1(unit = "kg") = 32 "Mass of Na2SO4 in solution" ;
parameter Real m2(unit = "kg") = 68 "Mass of H2O in solution" ;
parameter Real m = 19.4 "Na2SO4 in final mother liquor per 100 kg of H2O" ;

//======================================================
//Variable Section
Real m3(unit = "kg") "Water associated with Na2SO4" ;
Real m4(unit = "kg") "Free water" ;
Real m5(unit = "kg") "Glauber salt in 100 kg of free water" ;
Real m6(unit = "kg") "Water associated with Na2SO4" ;
Real m7(unit = "kg") "Free water associated with final mother liquor" ;
Real m8(unit = "kg") "Glauber salt in 100 kg free water in final mother liquor" ;
Real yield "Yield of glauber salt" ;

//======================================================
//Equation Section
equation
m3 = (180/142)*m1 ;
m4 = m2-m3 ;
m5 = (m1+m3)*100/m4 ;
m6 = 180*m/142 ;
m7 = F-m6 ;
m8 = (m+m6)/m7*100 ;
yield = (m5-m8)/m5*100 ;

end Ex6_9;
//======================================================
