//Bhatt B. I. and Thakore S. B., Stoichiometry, 5th Edn., Tata McGraw Hill Education, 2010
//Chapter-7: Combustion
//Example: 7.10 Page 468
//Title: Atomisation of fuel oil

//======================================================
package Ex7_10

//======================================================
model Ex7_10_a
/* NCV of fuel */

//======================================================
//Parameter Section
parameter Real H2O(unit = "kmol") = 4.5 "Water vapour formed" ;

//======================================================
//Variable Section
Real m1(unit = "kg") "Water vapour formed" ;
Real l(unit = "kJ/kg") "Latent heat lost in water vapour per 100 kg of fuel" ;
Real NCV(unit = "kJ/kg") "NCV" ;

//======================================================
//Equation Section
equation
m1 = H2O*18 ;
l = 2442.8*m1/100 ;
NCV = 43540-l ;

end Ex7_10_a ;
//======================================================

//======================================================
model Ex7_10_b
/* Theoretical air requirement */

//======================================================
//Parameter Section
parameter Real theo_O2(unit = "kmol") = 9.364 "Theoretical O2 requirement" ;

//======================================================
//Variable Section
Real N2(unit = "kmol") "N2 entering with O2" ;
Real tot_N2(unit = "kmol") "Total N2 in flue gas" ;
Real air "Total air per kg of fuel oil" ;

//======================================================
//Equation Section
equation
N2 = (79/21)*theo_O2 ;
tot_N2 = N2+0.036 ;
air = (theo_O2*32+tot_N2*28)/100 ;

end Ex7_10_b ;
//======================================================

//======================================================
model Ex7_10_c
/* Adiabatic temperature for theo. air */

//======================================================
//Parameter Section
parameter Real T0(unit = "K") = 298.15 "Reference temperature" ;
parameter Real T1(unit = "K") = 1500 "Temperature of flue gas" ;

//======================================================
//Reference Section
extends Ex7_10_a ;

//======================================================
//Variable Section
Real H71(unit = "kJ") "Enthalpy of fuel gas up to 1500 K" ;
Real H1(unit = "kJ") "Total heat liberated by complete combustion" ;
Real H(unit = "kJ") "Enthalpy of flue gas above 1500 K" ;
Real T(unit = "K",start = 0) "Adiabatic flame temperature" ;

//======================================================
//Equation Section
equation
//Using heat capacity data from Table 7.25
H1 = 100*NCV ;
H71 = 1349.726*(T1-T0)+252.924*10^(-3)* (T1^2-T0^2)/2+257.436*10^(-6)*(T1^3-T0^3)/3-137.532*10^(-9)*(T1^4-T0^4)/4 ;
H = H1-H71 ;
H = 1477.301*(T-T1)+375.27*10^(-3)*(T^2-T1^2)/2-91.276*10^(-6)*(T^3-T1^3)/3+8.146*10^(-9)*(T^4-T1^4)/4 ;
end Ex7_10_c ;
//======================================================

//======================================================
model Ex7_10_d
/* Adiabatic flame temp. for 30% excess air */

//======================================================
//Parameter Section
parameter Real T0(unit = "K") = 298.15 "Reference temperature" ;
parameter Real T1(unit = "K") = 1500 "Temperature of flue gas" ;

//======================================================
//Reference Section
extends Ex7_10_a ;

//======================================================
//Variable Section
Real O2(unit = "kmol") "Actual supply of O2" ;
Real H71(unit = "kJ") "Enthalpy of fuel gas up to 1500 K" ;
Real H1(unit = "kJ") "Total heat liberated" ;
Real H(unit = "kJ") "Enthalpy of flue gas above 1500 K" ;
Real T(unit = "K",start = 0) "Adiabatic flame temperature" ;

//======================================================
//Equation Section
equation
O2 = 9.364*1.3 ;
//Using Table 7.26 and 7.27
H1 = 100*NCV ;
H71 = 1735.651*(T1-T0)+227.543*10^(-3)*(T1^2-T0^2)/2+402.304*10^(-6)*(T1^3-T0^3)/3-194.858*10^(-9)*(T1^4-T0^4)/4 ;
H = H1-H71 ;
H = 1857.937*(T-T1)+470.059*10^(-3)*(T^2-T1^2)/2-118.886*10^(-6)*(T^3-T1^3)/3+11.417*10^(-9)*(T^4-T1^4)/4 ;

end Ex7_10_d ;
//======================================================

//======================================================
model Ex7_10_e
/* Acid dew point */

//======================================================
//Variable Section
Real T(unit = "K") "Acid dew point" ;

//======================================================
//Equation Section
equation
//For C/H ratio = 1.574 and 30% excess air from Fig. 7.3
T = 429 ;

end Ex7_10_e ;
//======================================================

//======================================================
model Ex7_10_f
/* Adiabatic flame temp. for incomplete combustion */

//======================================================
//Parameter Section
parameter Real CO(unit = "kmol") = 0.708 "C burnt to CO" ;
parameter Real CO2(unit = "kmol") = 6.375 "C burnt to CO2" ;
parameter Real T0(unit = "K") = 298.15 "Reference temperature" ;
parameter Real T1(unit = "K") = 1500 "Temperature of flue gas" ;

//======================================================
//Reference Section
extends Ex7_10_a ;

//======================================================
//Variable Section
Real O2(unit = "kmol") "O2 for combustion of C" ;
Real O2_s(unit = "kmol") "O2 supplied" ;
Real N2(unit = "kmol") "N2 entering" ;
Real T_N2(unit = "kmol") "Total N2" ;
Real H2(unit = "kJ/kmol") "Heat of combustion of CO to CO2" ;
Real H3(unit = "kJ") "Unavailable heat due to CO formation" ;
Real H71(unit = "kJ") "Enthalpy of fuel gas up to 1500 K" ;
Real H11(unit = "kJ") "Total heat liberated" ;
Real H(unit = "kJ") "Enthalpy of flue gas above 1500 K" ;
Real T(unit = "K",start = 0) "Adiabatic flame temperature" ;

//======================================================
//Equation Section
equation
O2 = CO2+CO/2 ;
O2_s = O2+2.250+0.094-0.063 ;
N2 = (79/21)*O2_s ;
T_N2 = N2+0.036 ;
H2 = 282980 ;
H3 = H2*CO ;
H11 = 100*NCV - H3 ;
//Using Table 7.28 and 7.29
H71 = 1315.753*(T1-T0)+212.772*10^(-3)*(T1^2-T0^2)/2+281.312*10^(-6)*(T1^3-T0^3)/3-140.784*10^(-9)*(T1^4-T0^4)/4 ;
H = H11-H71 ;
H = 1458.975*(T-T1)+360.665*10^(-3)*(T^2-T1^2)/2-87.427*10^(-6)*(T^3-T1^3)/3+7.777*10^(-9)*(T^4-T1^4)/4 ;

end Ex7_10_f ;
//======================================================

end Ex7_10;
//======================================================
